/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.AncientWarfareAutomation;
import net.shadowmage.ancientwarfare.automation.chunkloader.AWChunkLoader;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBase;
import net.shadowmage.ancientwarfare.core.interfaces.IBoundedSite;
import net.shadowmage.ancientwarfare.core.interfaces.IChunkLoaderTile;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public abstract class TileWorksiteBounded
extends TileWorksiteBase
implements IBoundedSite,
IChunkLoaderTile {
    private static final String BB_MIN_TAG = "bbMin";
    private static final String BB_MAX_TAG = "bbMax";
    private BlockPos bbMin = BlockPos.field_177992_a;
    private BlockPos bbMax = BlockPos.field_177992_a;
    ForgeChunkManager.Ticket chunkTicket = null;

    @Override
    public Set<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.of(WorksiteUpgrade.ENCHANTED_TOOLS_1, new WorksiteUpgrade[]{WorksiteUpgrade.ENCHANTED_TOOLS_2, WorksiteUpgrade.SIZE_MEDIUM, WorksiteUpgrade.SIZE_LARGE, WorksiteUpgrade.TOOL_QUALITY_1, WorksiteUpgrade.TOOL_QUALITY_2, WorksiteUpgrade.TOOL_QUALITY_3, WorksiteUpgrade.BASIC_CHUNK_LOADER});
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        super.onBlockBroken(state);
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
        super.addUpgrade(upgrade);
        if (upgrade == WorksiteUpgrade.BASIC_CHUNK_LOADER || upgrade == WorksiteUpgrade.QUARRY_CHUNK_LOADER) {
            this.setupInitialTicket();
        }
    }

    @Override
    public final void removeUpgrade(WorksiteUpgrade upgrade) {
        super.removeUpgrade(upgrade);
        if (upgrade == WorksiteUpgrade.BASIC_CHUNK_LOADER || upgrade == WorksiteUpgrade.QUARRY_CHUNK_LOADER) {
            this.setTicket(null);
        }
    }

    @Override
    public final boolean hasWorkBounds() {
        return !this.bbMin.equals((Object)BlockPos.field_177992_a) && !this.bbMax.equals((Object)BlockPos.field_177992_a);
    }

    @Override
    public final BlockPos getWorkBoundsMin() {
        return this.bbMin;
    }

    @Override
    public final BlockPos getWorkBoundsMax() {
        return this.bbMax;
    }

    @Override
    public final void setBounds(BlockPos min, BlockPos max) {
        this.setWorkBoundsMin(BlockTools.getMin(min, max));
        this.setWorkBoundsMax(BlockTools.getMax(min, max));
        this.onBoundsSet();
    }

    @Override
    public int getBoundsMaxWidth() {
        if (this.getUpgrades().contains((Object)WorksiteUpgrade.SIZE_LARGE)) {
            return 16;
        }
        if (this.getUpgrades().contains((Object)WorksiteUpgrade.SIZE_MEDIUM)) {
            return 9;
        }
        return 5;
    }

    @Override
    public int getBoundsMaxHeight() {
        return 1;
    }

    @Override
    public final void setTicket(@Nullable ForgeChunkManager.Ticket tk) {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
        this.chunkTicket = tk;
        if (this.chunkTicket == null) {
            return;
        }
        AWChunkLoader.INSTANCE.writeDataToTicket(this.chunkTicket, this.field_174879_c);
        ChunkPos ccip = new ChunkPos(this.field_174879_c);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)ccip);
        if (this.hasWorkBounds()) {
            this.chunkLoadWorkBounds();
        }
    }

    protected void chunkLoadWorkBounds() {
        int minX = this.getWorkBoundsMin().func_177958_n() >> 4;
        int minZ = this.getWorkBoundsMin().func_177952_p() >> 4;
        int maxX = this.getWorkBoundsMax().func_177958_n() >> 4;
        int maxZ = this.getWorkBoundsMax().func_177952_p() >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                ChunkPos ccip = new ChunkPos(x, z);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)ccip);
            }
        }
    }

    private void setupInitialTicket() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        if (this.hasChunkLoaderUpgrade()) {
            this.setTicket(ForgeChunkManager.requestTicket((Object)AncientWarfareAutomation.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL));
        }
    }

    boolean hasChunkLoaderUpgrade() {
        return this.getUpgrades().contains((Object)WorksiteUpgrade.BASIC_CHUNK_LOADER) || this.getUpgrades().contains((Object)WorksiteUpgrade.QUARRY_CHUNK_LOADER);
    }

    protected void onBoundsSet() {
    }

    @Override
    public void onBoundsAdjusted() {
    }

    @Override
    public void onPostBoundsAdjusted() {
        this.setupInitialTicket();
    }

    boolean isInBounds(BlockPos pos) {
        return pos.func_177958_n() >= this.bbMin.func_177958_n() && pos.func_177958_n() <= this.bbMax.func_177958_n() && pos.func_177952_p() >= this.bbMin.func_177952_p() && pos.func_177952_p() <= this.bbMax.func_177952_p();
    }

    protected void validateCollection(Collection<BlockPos> blocks) {
        BlockPos pos;
        if (!this.hasWorkBounds()) {
            blocks.clear();
            return;
        }
        Iterator<BlockPos> it = blocks.iterator();
        while (it.hasNext() && (pos = it.next()) != null) {
            if (this.isInBounds(pos)) continue;
            it.remove();
        }
    }

    @Override
    public final void setWorkBoundsMin(BlockPos min) {
        if (min != this.bbMin) {
            this.bbMin = min;
            this.func_70296_d();
        }
    }

    @Override
    public final void setWorkBoundsMax(BlockPos max) {
        if (max != this.bbMax) {
            this.bbMax = max;
            this.func_70296_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.hasWorkBounds()) {
            BlockPos min = this.getWorkBoundsMin();
            int minX = Math.min(min.func_177958_n(), this.field_174879_c.func_177958_n());
            int minY = Math.min(min.func_177956_o(), this.field_174879_c.func_177956_o());
            int minZ = Math.min(min.func_177952_p(), this.field_174879_c.func_177952_p());
            BlockPos max = this.getWorkBoundsMax();
            int maxX = Math.max(max.func_177958_n() + 1, this.field_174879_c.func_177958_n() + 1);
            int maxY = Math.max(max.func_177956_o() + 1, this.field_174879_c.func_177956_o() + 1);
            int maxZ = Math.max(max.func_177952_p() + 1, this.field_174879_c.func_177952_p() + 1);
            return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b(BB_MIN_TAG)) {
            this.bbMin = BlockPos.func_177969_a((long)tag.func_74763_f(BB_MIN_TAG));
        }
        if (tag.func_74764_b(BB_MAX_TAG)) {
            this.bbMax = BlockPos.func_177969_a((long)tag.func_74763_f(BB_MAX_TAG));
        }
        if (this.bbMax == BlockPos.field_177992_a) {
            this.setWorkBoundsMax(this.field_174879_c.func_177982_a(0, 0, 1));
        }
        if (this.bbMin == BlockPos.field_177992_a) {
            this.setWorkBoundsMin(this.field_174879_c.func_177982_a(0, 0, 1));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.bbMin != BlockPos.field_177992_a) {
            tag.func_74772_a(BB_MIN_TAG, this.bbMin.func_177986_g());
        }
        if (this.bbMax != BlockPos.field_177992_a) {
            tag.func_74772_a(BB_MAX_TAG, this.bbMax.func_177986_g());
        }
        return tag;
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        if (this.bbMin != BlockPos.field_177992_a) {
            tag.func_74772_a(BB_MIN_TAG, this.bbMin.func_177986_g());
        }
        if (this.bbMax != BlockPos.field_177992_a) {
            tag.func_74772_a(BB_MAX_TAG, this.bbMax.func_177986_g());
        }
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        if (tag.func_74764_b(BB_MIN_TAG)) {
            this.bbMin = BlockPos.func_177969_a((long)tag.func_74763_f(BB_MIN_TAG));
        }
        if (tag.func_74764_b(BB_MAX_TAG)) {
            this.bbMax = BlockPos.func_177969_a((long)tag.func_74763_f(BB_MAX_TAG));
        }
    }
}

