/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.entity.AWFakePlayer;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public abstract class TileWorksiteFarm
extends TileWorksiteBoundedInventory {
    private static final int PLANTABLE_INVENTORY_SIZE = 3;
    private static final int SIZE = 16;
    public static final int DEFAULT_MISC_INVENTORY_SIZE = 3;
    private byte[] targetMap = new byte[256];
    private final Queue<BlockPos> blocksToUpdate = new LinkedList<BlockPos>();
    public final ItemStackHandler plantableInventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TileWorksiteFarm.this.shouldCountResources = true;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return TileWorksiteFarm.this.isPlantable(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    public final ItemStackHandler miscInventory = new ItemStackHandler(this.getMiscInventorySize()){

        protected void onContentsChanged(int slot) {
            TileWorksiteFarm.this.shouldCountResources = true;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return TileWorksiteFarm.this.isMiscItem(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    protected int plantableCount;
    protected int bonemealCount;
    private boolean shouldCountResources = true;

    public TileWorksiteFarm() {
        this.setSideInventory(BlockRotationHandler.RelativeSide.FRONT, (IItemHandler)this.plantableInventory, BlockRotationHandler.RelativeSide.FRONT);
        this.setSideInventory(BlockRotationHandler.RelativeSide.BOTTOM, (IItemHandler)this.miscInventory, BlockRotationHandler.RelativeSide.TOP);
    }

    protected boolean isMiscItem(ItemStack stack) {
        return this.isBonemeal(stack);
    }

    protected int getMiscInventorySize() {
        return 3;
    }

    protected abstract boolean isPlantable(ItemStack var1);

    protected abstract void scanBlockPosition(BlockPos var1);

    @Override
    protected final void updateWorksite() {
        this.field_145850_b.field_72984_F.func_76320_a("Incremental Scan");
        if (this.blocksToUpdate.isEmpty() && this.hasWorkBounds()) {
            this.fillBlocksToProcess(this.blocksToUpdate);
        }
        if (!this.blocksToUpdate.isEmpty()) {
            BlockPos pos = this.blocksToUpdate.poll();
            this.scanBlockPosition(pos);
        }
        this.field_145850_b.field_72984_F.func_76319_b();
        this.updateBlockWorksite();
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        super.onBlockBroken(state);
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.plantableInventory, this.field_174879_c);
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.miscInventory, this.field_174879_c);
    }

    protected boolean harvestBlock(BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)this.field_145850_b, pos)) {
            return false;
        }
        NonNullList stacks = NonNullList.func_191196_a();
        block.getDrops(stacks, (IBlockAccess)this.field_145850_b, pos, state, this.getFortune());
        if (!this.inventoryCanHold((NonNullList<ItemStack>)stacks)) {
            return false;
        }
        if (!BlockTools.breakBlockNoDrops(this.field_145850_b, pos, state)) {
            return false;
        }
        this.insertOrDropCrops(pos, (NonNullList<ItemStack>)stacks);
        return true;
    }

    private boolean inventoryCanHold(NonNullList<ItemStack> stacks) {
        List<ItemStack> remainingStacks = InventoryTools.insertItems((IItemHandler)this.plantableInventory, stacks, true);
        remainingStacks = InventoryTools.insertItems((IItemHandler)this.mainInventory, remainingStacks, true);
        return remainingStacks.isEmpty();
    }

    private void insertOrDropCrops(BlockPos pos, NonNullList<ItemStack> stacks) {
        List<ItemStack> remainingItems = InventoryTools.insertItems((IItemHandler)this.plantableInventory, stacks, false);
        InventoryTools.insertOrDropItems((IItemHandler)this.mainInventory, remainingItems, this.field_145850_b, pos);
    }

    @Override
    public final boolean userAdjustableBlocks() {
        return true;
    }

    boolean isTarget(BlockPos p) {
        return this.isTarget(p.func_177958_n(), p.func_177952_p());
    }

    private boolean isTarget(int x1, int y1) {
        int z = (y1 - this.getWorkBoundsMin().func_177952_p()) * 16 + x1 - this.getWorkBoundsMin().func_177958_n();
        return z >= 0 && z < this.targetMap.length && this.targetMap[z] == 1;
    }

    protected boolean isBonemeal(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151100_aR && stack.func_77952_i() == EnumDyeColor.WHITE.func_176767_b();
    }

    boolean isFarmable(Block block) {
        return this.isFarmable(block, new BlockPos(0, 0, 0));
    }

    protected boolean isFarmable(Block block, BlockPos farmablePos) {
        return block instanceof IPlantable;
    }

    protected boolean canReplace(BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        return state.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, pos);
    }

    protected boolean tryPlace(ItemStack stack, BlockPos pos, EnumFacing face) {
        return BlockTools.placeItemBlock(stack, this.field_145850_b, pos, face);
    }

    private void pickupItems() {
        List<EntityItem> items = EntityTools.getEntitiesWithinBounds(this.field_145850_b, EntityItem.class, this.getWorkBoundsMin(), this.getWorkBoundsMax());
        if (items.isEmpty()) {
            return;
        }
        for (EntityItem item : items) {
            ItemStack stack;
            if (!item.func_70089_S() || (stack = item.func_92059_d()).func_190926_b()) continue;
            stack = InventoryTools.mergeItemStack((IItemHandler)this.plantableInventory, stack);
            if (!(stack = InventoryTools.mergeItemStack((IItemHandler)this.mainInventory, stack)).func_190926_b()) {
                item.func_92058_a(stack);
                continue;
            }
            item.func_70106_y();
        }
    }

    @Override
    protected void validateCollection(Collection<BlockPos> blocks) {
        BlockPos pos;
        if (!this.hasWorkBounds()) {
            blocks.clear();
            return;
        }
        Iterator<BlockPos> it = blocks.iterator();
        while (it.hasNext() && (pos = it.next()) != null) {
            if (this.isInBounds(pos) && this.isTarget(pos)) continue;
            it.remove();
        }
    }

    private void fillBlocksToProcess(Collection<BlockPos> targets) {
        BlockPos min = this.getWorkBoundsMin();
        BlockPos max = this.getWorkBoundsMax();
        for (int x = min.func_177958_n(); x < max.func_177958_n() + 1; ++x) {
            for (int z = min.func_177952_p(); z < max.func_177952_p() + 1; ++z) {
                if (!this.isTarget(x, z)) continue;
                targets.add(new BlockPos(x, min.func_177956_o(), z));
            }
        }
    }

    public void onTargetsAdjusted() {
        this.onBoundsAdjusted();
    }

    @Override
    protected void onBoundsSet() {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.targetMap[z * 16 + x] = 1;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74773_a("targetMap", this.targetMap);
        tag.func_74782_a("plantableInventory", (NBTBase)this.plantableInventory.serializeNBT());
        tag.func_74782_a("miscInventory", (NBTBase)this.miscInventory.serializeNBT());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("targetMap")) {
            this.targetMap = tag.func_74770_j("targetMap");
        }
        this.plantableInventory.deserializeNBT(tag.func_74775_l("plantableInventory"));
        this.miscInventory.deserializeNBT(tag.func_74775_l("miscInventory"));
    }

    public byte[] getTargetMap() {
        return this.targetMap;
    }

    public void setTargetBlocks(byte[] targets) {
        boolean change = !Objects.deepEquals(this.targetMap, targets);
        this.targetMap = targets;
        if (change) {
            this.onTargetsAdjusted();
            this.func_70296_d();
        }
    }

    private void updateBlockWorksite() {
        this.field_145850_b.field_72984_F.func_76320_a("Items Pickup");
        if (this.field_145850_b.func_72820_D() % 20L == 0L) {
            this.pickupItems();
        }
        this.field_145850_b.field_72984_F.func_76318_c("Count Resources");
        if (this.shouldCountResources) {
            this.countResources();
            this.shouldCountResources = false;
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    protected void countResources() {
        this.plantableCount = InventoryTools.getCountOf((IItemHandler)this.plantableInventory, this::isPlantable);
        this.bonemealCount = InventoryTools.getCountOf((IItemHandler)this.miscInventory, this::isBonemeal);
    }

    protected boolean fertilize(BlockPos pos) {
        Optional<ItemStack> stack = InventoryTools.stream((IItemHandler)this.miscInventory).filter(this::isBonemeal).findFirst();
        if (stack.isPresent() && ItemDye.applyBonemeal((ItemStack)stack.get(), (World)this.field_145850_b, (BlockPos)pos, (EntityPlayer)AWFakePlayer.get(this.field_145850_b), (EnumHand)EnumHand.MAIN_HAND)) {
            this.field_145850_b.func_175718_b(2005, pos, 0);
            return true;
        }
        return false;
    }
}

