/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core;

import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.shadowmage.ancientwarfare.core.AWCoreTab;
import net.shadowmage.ancientwarfare.core.command.CommandResearch;
import net.shadowmage.ancientwarfare.core.command.CommandUtils;
import net.shadowmage.ancientwarfare.core.compat.CompatLoader;
import net.shadowmage.ancientwarfare.core.compat.ftb.FTBCompat;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.container.ContainerBackpack;
import net.shadowmage.ancientwarfare.core.container.ContainerEngineeringStation;
import net.shadowmage.ancientwarfare.core.container.ContainerInfoTool;
import net.shadowmage.ancientwarfare.core.container.ContainerManual;
import net.shadowmage.ancientwarfare.core.container.ContainerResearchBook;
import net.shadowmage.ancientwarfare.core.container.ContainerResearchStation;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.datafixes.AWDataFixes;
import net.shadowmage.ancientwarfare.core.entity.AWFakePlayer;
import net.shadowmage.ancientwarfare.core.init.AWCoreItems;
import net.shadowmage.ancientwarfare.core.init.AWCoreLoot;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.proxy.CommonProxyBase;
import net.shadowmage.ancientwarfare.core.registry.RegistryLoader;
import net.shadowmage.ancientwarfare.core.registry.ResearchRegistry;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="Ancient Warfare Core", modid="ancientwarfare", version="1.12.2-2.7.0.772", guiFactory="net.shadowmage.ancientwarfare.core.gui.options.OptionsGuiFactory", dependencies="required:forge@[14.23.5.2815,);required-after:codechickenlib@[3.2.1,);", acceptedMinecraftVersions="[1.12.2]")
public class AncientWarfareCore {
    public static final String MOD_ID = "ancientwarfare";
    public static final CreativeTabs TAB = new AWCoreTab();
    @Mod.Instance(value="ancientwarfare")
    public static AncientWarfareCore instance;
    @SidedProxy(clientSide="net.shadowmage.ancientwarfare.core.proxy.ClientProxy", serverSide="net.shadowmage.ancientwarfare.core.proxy.CommonProxyBase")
    public static CommonProxyBase proxy;
    public static final Logger LOG;
    public static AWCoreStatics statics;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        statics = new AWCoreStatics("AncientWarfare");
        NetworkHandler.INSTANCE.registerNetwork();
        MinecraftForge.EVENT_BUS.register((Object)ResearchTracker.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkHandler.registerContainer(0, ContainerEngineeringStation.class);
        NetworkHandler.registerContainer(12, ContainerResearchStation.class);
        NetworkHandler.registerContainer(40, ContainerBackpack.class);
        NetworkHandler.registerContainer(45, ContainerResearchBook.class);
        NetworkHandler.registerContainer(56, ContainerManual.class);
        NetworkHandler.registerContainer(57, ContainerInfoTool.class);
        RegistryLoader.registerParser(new ResearchRegistry.ResearchParser());
        CompatLoader.registerCompat(new FTBCompat());
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        proxy.init();
        AWCoreItems.load();
        AWCraftingManager.registerIngredients();
        RegistryLoader.load();
        AWCraftingManager.loadRecipes();
        CompatLoader.init();
        AWDataFixes.registerDataFixes();
        AWCoreLoot.init();
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent evt) {
        statics.save();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStartingEvent(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandResearch());
        evt.registerServerCommand((ICommand)new CommandUtils());
    }

    @SubscribeEvent
    public void configChangedEvent(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (MOD_ID.equals(evt.getModID())) {
            statics.save();
        }
    }

    @SubscribeEvent
    public void createResearchRecipeRegistry(RegistryEvent.NewRegistry evt) {
        AWCraftingManager.init();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldServer) {
            AWFakePlayer.onWorldUnload();
        }
    }

    static {
        LOG = LogManager.getLogger((String)MOD_ID);
    }
}

