/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public class RecipeResourceLocation {
    public static final RecipeResourceLocation NO_RECIPE_REGISTRY_NAME = new RecipeResourceLocation(RecipeType.NONE, "", "");
    private final RecipeType recipeType;
    private final ResourceLocation resourceLocation;
    private static final Pattern VALID_PATTERN = Pattern.compile("([a-z_]+)\\|(.+:.+)");

    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public RecipeResourceLocation(RecipeType recipeType, ResourceLocation resourceLocation) {
        this.recipeType = recipeType;
        this.resourceLocation = resourceLocation;
    }

    public RecipeResourceLocation(RecipeType recipeType, String resourceDomain, String resourcePath) {
        this(recipeType, new ResourceLocation(resourceDomain, resourcePath));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipeResourceLocation other = (RecipeResourceLocation)o;
        return this.recipeType == other.recipeType && this.resourceLocation.equals((Object)other.resourceLocation);
    }

    public int hashCode() {
        int result = this.recipeType.hashCode();
        result = 31 * result + this.resourceLocation.hashCode();
        return result;
    }

    public String toString() {
        return this.recipeType.func_176610_l() + "|" + this.resourceLocation.toString();
    }

    public static RecipeResourceLocation deserialize(String recipeResourceLocation) {
        Matcher match = VALID_PATTERN.matcher(recipeResourceLocation);
        if (match.find() && !match.group(1).equals(RecipeType.NONE.func_176610_l())) {
            return new RecipeResourceLocation(RecipeType.deserialize(match.group(1)), new ResourceLocation(match.group(2)));
        }
        return NO_RECIPE_REGISTRY_NAME;
    }

    public static enum RecipeType implements IStringSerializable
    {
        NONE,
        RESEARCH,
        REGULAR;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public static RecipeType deserialize(String name) {
            for (RecipeType type : RecipeType.values()) {
                if (!type.func_176610_l().equals(name)) continue;
                return type;
            }
            return NONE;
        }
    }
}

