/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Tooltip;
import net.shadowmage.ancientwarfare.core.interfaces.IContainerGuiCallback;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.interfaces.IWidgetSelection;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainerBase<T extends ContainerBase>
extends GuiContainer
implements IContainerGuiCallback,
ITooltipRenderer,
IWidgetSelection {
    private static LinkedList<Viewport> viewportStack = new LinkedList();
    private GuiElement selectedWidget = null;
    protected boolean shouldCloseOnVanillaKeys = true;
    private float partialRenderTick = 0.0f;
    private boolean initDone = false;
    private boolean shouldUpdate = false;
    private List<GuiElement> elements = new ArrayList<GuiElement>();
    private Tooltip elementTooltip;
    private int elementTooltipX;
    private int elementTooltipY;
    @Nonnull
    private ItemStack tooltipStack = ItemStack.field_190927_a;
    private int tooltipX;
    private int tooltipY;
    private ResourceLocation backgroundTexture;
    protected EntityPlayer player;

    protected GuiContainerBase(ContainerBase container, int xSize, int ySize) {
        super((Container)container);
        container.setGui(this);
        this.field_146999_f = xSize;
        this.field_147000_g = ySize;
        this.player = container.player;
        this.backgroundTexture = GuiElement.backgroundTextureLocation;
    }

    public GuiContainerBase(ContainerBase container) {
        this(container, 256, 240);
    }

    public final void setTexture(String name) {
        this.backgroundTexture = new ResourceLocation(name);
    }

    public final T getContainer() {
        return (T)((Object)((ContainerBase)this.field_147002_h));
    }

    @Override
    public void handleItemStackTooltipRender(ItemStack itemStack, int mouseX, int mouseY) {
        this.tooltipStack = itemStack;
        this.tooltipX = mouseX;
        this.tooltipY = mouseY;
    }

    @Override
    public void handleElementTooltipRender(Tooltip tooltip, int mouseX, int mouseY) {
        this.elementTooltip = tooltip;
        this.elementTooltipX = mouseX;
        this.elementTooltipY = mouseY;
    }

    protected void clearElements() {
        if (this.selectedWidget != null && this.elements.contains(this.selectedWidget)) {
            this.selectedWidget = null;
        }
        this.elements.clear();
    }

    protected void addGuiElement(GuiElement element) {
        this.elements.add(element);
    }

    protected void removeGuiElement(GuiElement element) {
        this.elements.remove(element);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int button = Mouse.getEventButton();
        boolean state = Mouse.getEventButtonState();
        int wheel = Mouse.getEventDWheel();
        int type = button >= 0 ? (state ? 8 : 4) : (wheel != 0 ? 16 : 32);
        ActivationEvent evt = new ActivationEvent(type, button, state, x, y, wheel);
        for (GuiElement element : this.elements) {
            element.handleMouseInput(evt);
        }
    }

    public void func_146282_l() throws IOException {
        int key = Keyboard.getEventKey();
        boolean state = Keyboard.getEventKeyState();
        char ch = Keyboard.getEventCharacter();
        ActivationEvent evt = new ActivationEvent(state ? 2 : 1, key, ch, state);
        for (GuiElement element : this.elements) {
            element.handleKeyboardInput(evt);
        }
        if (this.selectedWidget == null) {
            super.func_146282_l();
        }
    }

    protected void func_73869_a(char ch, int key) throws IOException {
        if (this.selectedWidget == null) {
            boolean isExitCommand;
            boolean bl = isExitCommand = key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i();
            if (isExitCommand) {
                if (this.shouldCloseOnVanillaKeys) {
                    this.closeGui();
                }
            } else {
                super.func_73869_a(ch, key);
            }
        }
    }

    protected final void closeGui() {
        if (this.onGuiCloseRequested()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    protected boolean onGuiCloseRequested() {
        return true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.initDone) {
            this.initElements();
            this.initDone = true;
        }
        this.setupElements();
        for (GuiElement element : this.elements) {
            element.updateGuiPosition(this.field_147003_i, this.field_147009_r);
        }
    }

    public void func_73876_c() {
        if (this.shouldUpdate) {
            ((ContainerBase)this.field_147002_h).setGui(this);
            this.func_73866_w_();
            this.shouldUpdate = false;
        }
        super.func_73876_c();
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.backgroundTexture != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.backgroundTexture);
            RenderTools.renderQuarteredTexture(256, 256, 0, 0, 256, 240, this.field_146294_l / 2 - this.field_146999_f / 2, this.field_146295_m / 2 - this.field_147000_g / 2, this.field_146999_f, this.field_147000_g);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiElement.widgetTexture1);
        for (Slot slot : this.field_147002_h.field_75151_b) {
            this.func_73729_b(slot.field_75223_e - 1 + this.field_147003_i, slot.field_75221_f - 1 + this.field_147009_r, 152, 120, 18, 18);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.partialRenderTick = partialTicks;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (!this.tooltipStack.func_190926_b()) {
            super.func_146285_a(this.tooltipStack, this.tooltipX, this.tooltipY);
            this.tooltipStack = ItemStack.field_190927_a;
        }
        if (this.elementTooltip != null) {
            this.elementTooltip.renderTooltip(this.elementTooltipX, this.elementTooltipY, this.partialRenderTick);
            this.elementTooltip = null;
        }
    }

    protected void func_146979_b(int par1, int par2) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        long time = System.currentTimeMillis();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (GuiElement element : this.elements) {
            element.render(par1, par2, this.partialRenderTick);
            element.postRender(par1, par2, this.partialRenderTick, time, this);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void refreshGui() {
        this.shouldUpdate = true;
    }

    public abstract void initElements();

    public abstract void setupElements();

    @Override
    public void handlePacketData(NBTTagCompound data) {
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        this.tooltipStack = stack;
        this.tooltipX = x;
        this.tooltipY = y;
    }

    @Override
    public void onWidgetSelected(GuiElement element) {
        this.selectedWidget = element;
        element.setSelected(true);
    }

    @Override
    public void onWidgetDeselected(GuiElement element) {
        if (this.selectedWidget == element) {
            this.selectedWidget = null;
        }
        element.setSelected(false);
    }

    public void onCompositeCleared(List<GuiElement> compositeElements) {
        if (compositeElements.contains(this.selectedWidget)) {
            this.selectedWidget = null;
        }
    }

    public static void pushViewport(int x, int y, int w, int h) {
        int tlx = x;
        int tly = y;
        int brx = x + w;
        int bry = y + h;
        Viewport p = viewportStack.peek();
        if (p != null) {
            if (tlx < p.x) {
                tlx = p.x;
            }
            if (brx > p.x + p.w) {
                brx = p.x + p.w;
            }
            if (tly < p.y) {
                tly = p.y;
            }
            if (bry > p.y + p.h) {
                bry = p.y + p.h;
            }
        }
        x = tlx;
        y = tly;
        w = brx - tlx;
        h = bry - tly;
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledRes = new ScaledResolution(mc);
        int guiScale = scaledRes.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(x * guiScale), (int)(mc.field_71440_d - y * guiScale - h * guiScale), (int)(w * guiScale), (int)(h * guiScale));
        viewportStack.push(new Viewport(x, y, w, h));
    }

    public static void popViewport() {
        Viewport p = viewportStack.poll();
        if (p == null) {
            GL11.glDisable((int)3089);
        }
        if ((p = viewportStack.peek()) != null) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution scaledRes = new ScaledResolution(mc);
            int guiScale = scaledRes.func_78325_e();
            GL11.glEnable((int)3089);
            GL11.glScissor((int)(p.x * guiScale), (int)(mc.field_71440_d - p.y * guiScale - p.h * guiScale), (int)(p.w * guiScale), (int)(p.h * guiScale));
        } else {
            GL11.glDisable((int)3089);
        }
    }

    private static class Viewport {
        int x;
        int y;
        int w;
        int h;

        private Viewport(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.h = h;
            this.w = w;
        }
    }

    public static class ActivationEvent {
        public final int type;
        public int key;
        public int mButton;
        public boolean state;
        public char ch;
        public int mx;
        public int my;
        public int mw;

        private ActivationEvent(int type, int button, boolean state, int mx, int my, int mw) {
            this.type = type;
            this.mButton = button;
            this.state = state;
            this.mx = mx;
            this.my = my;
            this.mw = mw;
        }

        private ActivationEvent(int type, int key, char character, boolean state) {
            this.type = type;
            this.key = key;
            this.ch = character;
            this.state = state;
        }
    }
}

