/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.interfaces.IScrollableCallback;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

@SideOnly(value=Side.CLIENT)
public class Scrollbar
extends GuiElement {
    private static final int MIN_HANDLE_HEIGHT = 10;
    static final int borderSize = 1;
    int totalAreaSize;
    int viewSize;
    double viewPercent;
    int handleTopMax;
    int handleTop;
    int handleWidth;
    int handleHeight;
    boolean pressed;
    boolean dragging;
    int lastMouseY;
    int topIndex;
    private IScrollableCallback parent;

    public Scrollbar(int topLeftX, int topLeftY, int width, int height, IScrollableCallback parentCaller) {
        super(topLeftX, topLeftY, width, height);
        this.viewSize = height - 2;
        this.handleTop = 0;
        this.handleHeight = this.viewSize;
        this.handleWidth = width - 2;
        this.setAreaSize(height);
        this.parent = parentCaller;
        this.addNewListener(new Listener(32){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Scrollbar.this.dragging) {
                    int dy = evt.my - Scrollbar.this.lastMouseY;
                    Scrollbar.this.handleTop += dy;
                    Scrollbar.this.lastMouseY = evt.my;
                    Scrollbar.this.updateHandlePosition();
                }
                return true;
            }
        });
        this.addNewListener(new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                Scrollbar.this.dragging = false;
                Scrollbar.this.pressed = false;
                Scrollbar.this.lastMouseY = evt.my;
                if (Scrollbar.this.isMouseOverHandle(evt.mx, evt.my)) {
                    Scrollbar.this.dragging = true;
                } else if (Scrollbar.this.isMouseOverElement(evt.mx, evt.my)) {
                    Scrollbar.this.pressed = true;
                }
                return true;
            }
        });
        this.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Scrollbar.this.enabled && Scrollbar.this.visible && Scrollbar.this.pressed && Scrollbar.this.isMouseOverElement(evt.mx, evt.my) && !Scrollbar.this.isMouseOverHandle(evt.mx, evt.my)) {
                    Scrollbar.this.handleTop = evt.my < Scrollbar.this.renderY + 1 + Scrollbar.this.handleTop ? (Scrollbar.this.handleTop -= Scrollbar.this.handleHeight) : (Scrollbar.this.handleTop += Scrollbar.this.handleHeight);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    Scrollbar.this.updateHandlePosition();
                }
                Scrollbar.this.dragging = false;
                Scrollbar.this.pressed = false;
                return true;
            }
        });
        this.addNewListener(new Listener(16){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    Scrollbar.this.handleMouseScroll(evt);
                }
                return true;
            }
        });
    }

    public void handleMouseScroll(GuiContainerBase.ActivationEvent evt) {
        this.handleTop -= evt.mw / 10;
        this.updateHandlePosition();
    }

    protected boolean isMouseOverHandle(int mouseX, int mouseY) {
        return mouseX >= this.renderX + 1 && mouseX < this.renderX + this.width - 1 && mouseY >= this.renderY + 1 + this.handleTop && mouseY < this.renderY + 1 + this.handleTop + this.handleHeight;
    }

    public void setAreaSize(int size) {
        this.totalAreaSize = size;
        this.viewPercent = (double)this.viewSize / (double)this.totalAreaSize;
        if (this.viewPercent > 1.0) {
            this.viewPercent = 1.0;
        }
        this.updateHandlePosition();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(widgetTexture1);
            RenderTools.renderQuarteredTexture(256, 256, 80, 120, 40, 128, this.renderX, this.renderY, this.width, this.height);
            RenderTools.renderQuarteredTexture(256, 256, 120, 120, 32, 128, this.renderX + 1, this.renderY + 1 + this.handleTop, this.handleWidth, this.handleHeight);
        }
    }

    protected void updateHandlePosition() {
        this.handleHeight = Math.max(10, (int)((double)this.viewSize * this.viewPercent));
        this.handleTopMax = this.viewSize - this.handleHeight;
        if (this.handleTop > this.handleTopMax) {
            this.handleTop = this.handleTopMax;
        }
        if (this.handleTop < 0) {
            this.handleTop = 0;
        }
        if (this.parent != null) {
            this.topIndex = (int)((float)(this.totalAreaSize - this.viewSize) * this.getPercentScrolled());
            this.parent.onScrolled(this.topIndex);
        }
    }

    private float getPercentScrolled() {
        return (float)this.handleTop / (float)this.handleTopMax;
    }

    public int getTopIndex() {
        return this.topIndex;
    }
}

