/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.item.ItemBaseCore;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class ItemHammer
extends ItemBaseCore
implements IItemKeyInterface {
    public static final String WORK_MODE_TAG = "workMode";
    private double attackDamage = 5.0;
    private Item.ToolMaterial material;

    public ItemHammer(String regName, Item.ToolMaterial material) {
        super(regName);
        this.attackDamage = 4.0f + material.func_78000_c();
        this.material = material;
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.setHarvestLevel("hammer", material.func_77996_d());
    }

    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        par1ItemStack.func_77972_a(1, par3EntityLivingBase);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (state.func_185887_b(world, pos) != 0.0f) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.attackDamage, 0));
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.1, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String key = InputHandler.ALT_ITEM_USE_1.getDisplayName();
        tooltip.add(I18n.func_135052_a((String)"guistrings.core.hammer.use_primary_item_key", (Object[])new Object[]{key}));
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n(WORK_MODE_TAG)) {
            tooltip.add(I18n.func_135052_a((String)"guistrings.core.hammer.work_mode", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"guistrings.core.hammer.rotate_mode", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        boolean mode = false;
        if (stack.func_77942_o()) {
            mode = stack.func_77978_p().func_74767_n(WORK_MODE_TAG);
        } else {
            stack.func_77982_d(new NBTTagCompound());
        }
        mode = !mode;
        stack.func_77978_p().func_74757_a(WORK_MODE_TAG, mode);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 0.3f, 0.6f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        RayTraceResult hit = this.func_77621_a(world, player, false);
        if (hit == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        boolean mode = false;
        if (stack.func_77942_o()) {
            mode = stack.func_77978_p().func_74767_n(WORK_MODE_TAG);
        } else {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (mode) {
            Optional<IWorkSite> te = WorldTools.getTile((IBlockAccess)world, hit.func_178782_a(), IWorkSite.class).filter(IWorkSite::hasWork);
            if (te.isPresent()) {
                te.get().addEnergyFromPlayer(player);
                this.playSound(world, hit, SoundEvents.field_187712_dQ);
            } else if (!world.func_175623_d(hit.func_178782_a())) {
                this.playBlockSound(world, hit, world.func_180495_p(hit.func_178782_a()));
            }
        } else if (!world.func_175623_d(hit.func_178782_a())) {
            IBlockState state = world.func_180495_p(hit.func_178782_a());
            if (state.func_177230_c().rotateBlock(world, hit.func_178782_a(), hit.field_178784_b)) {
                this.playSound(world, hit, SoundEvents.field_187715_dR);
            } else {
                this.playBlockSound(world, hit, state);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private void playSound(World world, RayTraceResult hit, SoundEvent sound) {
        world.func_184133_a(null, hit.func_178782_a(), sound, SoundCategory.BLOCKS, 0.2f, world.field_73012_v.nextFloat() * 0.15f + 0.6f);
    }

    private void playBlockSound(World world, RayTraceResult hit, IBlockState state) {
        SoundType sound = state.func_177230_c().getSoundType(state, world, hit.func_178782_a(), null);
        if (sound != null) {
            world.func_184133_a(null, hit.func_178782_a(), sound.func_185841_e(), SoundCategory.BLOCKS, sound.func_185843_a() * 0.5f, sound.func_185847_b() * 0.8f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

