/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class RegistryLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, IRegistryDataParser> parsers = new HashMap<String, IRegistryDataParser>();
    private static final Map<ResourceLocation, String> loadedRegistries = new HashMap<ResourceLocation, String>();
    private static final Map<Path, Set<String>> loadLater = new HashMap<Path, Set<String>>();

    private RegistryLoader() {
    }

    public static void registerParser(IRegistryDataParser parser) {
        parsers.put(parser.getName(), parser);
    }

    public static void load() {
        RegistryLoader.load(p -> true);
    }

    public static void reload(String type) {
        loadedRegistries.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(type));
        RegistryLoader.load(p -> p.getName().equals(type));
    }

    public static void load(Predicate<IRegistryDataParser> include) {
        ModContainer awModContainer = Loader.instance().activeModContainer();
        Path registryOverridesFolder = new File("config/ancientwarfare/registry").toPath();
        if (registryOverridesFolder.toFile().exists()) {
            RegistryLoader.loadRegistries(awModContainer, registryOverridesFolder, include);
        }
        RegistryLoader.loadRegistries(awModContainer, awModContainer.getSource(), "assets/" + awModContainer.getModId() + "/registry", include);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRegistries(ModContainer mod, File source, String base, Predicate<IRegistryDataParser> include) {
        if (!source.isDirectory() && !source.isFile()) {
            return;
        }
        FileSystem fs = null;
        try {
            Path root;
            if (source.isFile()) {
                fs = FileSystems.newFileSystem(source.toPath(), null);
                root = fs.getPath("/" + base, new String[0]);
            } else {
                root = source.toPath().resolve(base);
            }
            RegistryLoader.loadRegistries(mod, root, include);
        }
        catch (IOException e) {
            try {
                AncientWarfareCore.LOG.error("Error loading FileSystem from jar: ", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fs);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)fs);
        }
        IOUtils.closeQuietly((Closeable)fs);
    }

    private static void loadRegistries(ModContainer mod, Path root, Predicate<IRegistryDataParser> include) {
        Iterator itr;
        if (!Files.exists(root, new LinkOption[0])) {
            return;
        }
        try {
            itr = Files.walk(root, new FileVisitOption[0]).iterator();
        }
        catch (IOException e) {
            AncientWarfareCore.LOG.error("Error iterating filesystem for: {}", (Object)root, (Object)e);
            return;
        }
        while (itr != null && itr.hasNext()) {
            RegistryLoader.loadFile(mod, root, (Path)itr.next(), include, true);
        }
        RegistryLoader.loadDependents(mod, root, include);
    }

    private static void loadDependents(ModContainer mod, Path root, Predicate<IRegistryDataParser> include) {
        int lastCountLoadLater = loadLater.size();
        while (!loadLater.isEmpty()) {
            Iterator<Map.Entry<Path, Set<String>>> iterator = loadLater.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Path, Set<String>> entry = iterator.next();
                if (!RegistryLoader.areDependenciesLoaded(entry.getValue())) continue;
                RegistryLoader.loadFile(mod, root, entry.getKey(), include, false);
                iterator.remove();
            }
            if (lastCountLoadLater <= loadLater.size()) {
                RegistryLoader.logIncorrectDependencies();
                break;
            }
            lastCountLoadLater = loadLater.size();
        }
    }

    private static void logIncorrectDependencies() {
        for (Map.Entry<Path, Set<String>> entry : loadLater.entrySet()) {
            AncientWarfareCore.LOG.error("Non existent or circular load after dependencies in {} - {}", (Object)entry.getKey().toString(), (Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFile(ModContainer mod, Path root, Path file, Predicate<IRegistryDataParser> include, boolean checkDependencies) {
        Loader.instance().setActiveModContainer(mod);
        String relative = root.relativize(file).toString();
        if (!"json".equals(FilenameUtils.getExtension((String)file.toString()))) {
            return;
        }
        String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
        String shortName = name.substring(name.lastIndexOf(47) + 1);
        ResourceLocation registryName = new ResourceLocation(mod.getModId(), name);
        BufferedReader reader = null;
        try {
            Set<String> dependencies;
            reader = Files.newBufferedReader(file);
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            if (json == null) {
                return;
            }
            Optional<IRegistryDataParser> parser = RegistryLoader.getParser(shortName, json);
            if (!parser.isPresent()) {
                AncientWarfareCore.LOG.error("No parser defined for file name {}", (Object)shortName);
                return;
            }
            if (checkDependencies && json.has("load_after") && !RegistryLoader.areDependenciesLoaded(dependencies = JsonHelper.setFromJson(json.get("load_after"), e -> JsonUtils.func_151206_a((JsonElement)e, (String)"")))) {
                loadLater.put(file, dependencies);
                return;
            }
            if (loadedRegistries.containsKey(registryName)) {
                AncientWarfareCore.LOG.info("Registry {} has already been loaded in overrides, skipping...", (Object)registryName.toString());
                return;
            }
            loadedRegistries.put(registryName, parser.get().getName());
            if (!include.test(parser.get()) || RegistryLoader.isDisabled(json) || !RegistryLoader.isModLoaded(json)) {
                return;
            }
            parser.get().parse(json);
        }
        catch (JsonParseException e2) {
            AncientWarfareCore.LOG.error("Parsing error loading registry {}", (Object)registryName, (Object)e2);
        }
        catch (MissingResourceException e3) {
            AncientWarfareCore.LOG.error(e3.getMessage());
        }
        catch (IOException e4) {
            AncientWarfareCore.LOG.error("Couldn't read registry {} from {}", (Object)registryName, (Object)file, (Object)e4);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private static boolean areDependenciesLoaded(Set<String> dependencies) {
        for (String dependency : dependencies) {
            if (loadedRegistries.containsValue(dependency)) continue;
            return false;
        }
        return true;
    }

    private static boolean isModLoaded(JsonObject json) {
        return !JsonUtils.func_151204_g((JsonObject)json, (String)"mod") || Loader.isModLoaded((String)JsonUtils.func_151200_h((JsonObject)json, (String)"mod"));
    }

    private static boolean isDisabled(JsonObject json) {
        return json.has("disabled") && JsonUtils.func_151212_i((JsonObject)json, (String)"disabled");
    }

    private static Optional<IRegistryDataParser> getParser(String fileName, JsonObject json) {
        String parserName = fileName;
        if (json.has("type")) {
            parserName = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        }
        return parsers.containsKey(parserName) ? Optional.of(parsers.get(parserName)) : Optional.empty();
    }
}

