/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;

public class ResearchRegistry {
    private static final Map<String, ResearchGoal> researchGoals = new HashMap<String, ResearchGoal>();

    private ResearchRegistry() {
    }

    @Nullable
    public static ResearchGoal getResearch(String researchName) {
        return researchGoals.get(researchName);
    }

    public static boolean researchExists(String researchName) {
        return researchGoals.containsKey(researchName);
    }

    public static Collection<ResearchGoal> getAllResearchGoals() {
        return researchGoals.values();
    }

    public static class ResearchParser
    implements IRegistryDataParser {
        @Override
        public String getName() {
            return "research";
        }

        @Override
        public void parse(JsonObject json) {
            String name = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
            int time = JsonUtils.func_151203_m((JsonObject)json, (String)"time");
            Set<String> dependencies = this.getDependencies(json);
            Set<Ingredient> resources = this.getResources(json);
            researchGoals.put(name, new ResearchGoal(name, dependencies, resources, time));
        }

        private Set<Ingredient> getResources(JsonObject json) {
            JsonArray res = JsonUtils.func_151214_t((JsonObject)json, (String)"resources");
            JsonContext context = new JsonContext("ancientwarfare");
            return StreamSupport.stream(res.spliterator(), false).map(e -> CraftingHelper.getIngredient((JsonElement)e, (JsonContext)context)).collect(Collectors.toSet());
        }

        private Set<String> getDependencies(JsonObject json) {
            JsonArray deps = JsonUtils.func_151214_t((JsonObject)json, (String)"dependencies");
            return StreamSupport.stream(deps.spliterator(), false).map(e -> JsonUtils.func_151206_a((JsonElement)e, (String)"")).collect(Collectors.toSet());
        }
    }
}

