/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.entity.AWFakePlayer;
import net.shadowmage.ancientwarfare.core.util.RegistryTools;
import net.shadowmage.ancientwarfare.core.util.parsing.PropertyState;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;

public class BlockTools {
    private static final Map<Class, IRotator<?>> ROTATORS = new ImmutableMap.Builder().put(EnumFacing.class, (Object)new IRotator<EnumFacing>(){

        @Override
        public EnumFacing rotateY(EnumFacing facing, int turns) {
            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                return facing;
            }
            for (int i = 0; i < turns; ++i) {
                facing = facing.func_176746_e();
            }
            return facing;
        }
    }).put(BlockLever.EnumOrientation.class, (Object)new IRotator<BlockLever.EnumOrientation>(){

        @Override
        public BlockLever.EnumOrientation rotateY(BlockLever.EnumOrientation orientation, int turns) {
            for (int i = 0; i < turns; ++i) {
                orientation = this.rotateYLeverOrientation(orientation);
            }
            return orientation;
        }

        private BlockLever.EnumOrientation rotateYLeverOrientation(BlockLever.EnumOrientation orientation) {
            switch (orientation) {
                case UP_X: {
                    return BlockLever.EnumOrientation.UP_Z;
                }
                case UP_Z: {
                    return BlockLever.EnumOrientation.UP_X;
                }
                case DOWN_X: {
                    return BlockLever.EnumOrientation.DOWN_Z;
                }
                case DOWN_Z: {
                    return BlockLever.EnumOrientation.DOWN_X;
                }
                case NORTH: {
                    return BlockLever.EnumOrientation.EAST;
                }
                case EAST: {
                    return BlockLever.EnumOrientation.SOUTH;
                }
                case SOUTH: {
                    return BlockLever.EnumOrientation.WEST;
                }
                case WEST: {
                    return BlockLever.EnumOrientation.NORTH;
                }
            }
            return orientation;
        }
    }).put(BlockLog.EnumAxis.class, (Object)new IRotator<BlockLog.EnumAxis>(){

        @Override
        public BlockLog.EnumAxis rotateY(BlockLog.EnumAxis facing, int turns) {
            if (facing == BlockLog.EnumAxis.Y || facing == BlockLog.EnumAxis.NONE || turns % 2 == 0) {
                return facing;
            }
            return facing == BlockLog.EnumAxis.X ? BlockLog.EnumAxis.Z : BlockLog.EnumAxis.X;
        }
    }).put(EnumFacing.Axis.class, (Object)new IRotator<EnumFacing.Axis>(){

        @Override
        public EnumFacing.Axis rotateY(EnumFacing.Axis facing, int turns) {
            if (facing == EnumFacing.Axis.Y || turns % 2 == 0) {
                return facing;
            }
            return facing == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        }
    }).put(BlockRailBase.EnumRailDirection.class, (Object)new IRotator<BlockRailBase.EnumRailDirection>(){

        @Override
        public BlockRailBase.EnumRailDirection rotateY(BlockRailBase.EnumRailDirection facing, int turns) {
            BlockRailBase.EnumRailDirection rotatedFacing = facing;
            for (int i = 0; i < turns; ++i) {
                rotatedFacing = this.rotateOnce(rotatedFacing);
            }
            return rotatedFacing;
        }

        private BlockRailBase.EnumRailDirection rotateOnce(BlockRailBase.EnumRailDirection facing) {
            switch (facing) {
                case NORTH_SOUTH: {
                    return BlockRailBase.EnumRailDirection.EAST_WEST;
                }
                case EAST_WEST: {
                    return BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                }
                case ASCENDING_EAST: {
                    return BlockRailBase.EnumRailDirection.ASCENDING_SOUTH;
                }
                case ASCENDING_SOUTH: {
                    return BlockRailBase.EnumRailDirection.ASCENDING_WEST;
                }
                case ASCENDING_WEST: {
                    return BlockRailBase.EnumRailDirection.ASCENDING_NORTH;
                }
                case ASCENDING_NORTH: {
                    return BlockRailBase.EnumRailDirection.ASCENDING_EAST;
                }
                case SOUTH_EAST: {
                    return BlockRailBase.EnumRailDirection.SOUTH_WEST;
                }
                case SOUTH_WEST: {
                    return BlockRailBase.EnumRailDirection.NORTH_WEST;
                }
                case NORTH_WEST: {
                    return BlockRailBase.EnumRailDirection.NORTH_EAST;
                }
            }
            return BlockRailBase.EnumRailDirection.SOUTH_EAST;
        }
    }).put(BlockHugeMushroom.EnumType.class, (Object)new IRotator<BlockHugeMushroom.EnumType>(){

        @Override
        public BlockHugeMushroom.EnumType rotateY(BlockHugeMushroom.EnumType facing, int turns) {
            BlockHugeMushroom.EnumType rotatedFacing = facing;
            for (int i = 0; i < turns; ++i) {
                rotatedFacing = this.rotateOnce(rotatedFacing);
            }
            return rotatedFacing;
        }

        private BlockHugeMushroom.EnumType rotateOnce(BlockHugeMushroom.EnumType rotatedFacing) {
            switch (rotatedFacing) {
                case NORTH_WEST: {
                    return BlockHugeMushroom.EnumType.NORTH_EAST;
                }
                case NORTH_EAST: {
                    return BlockHugeMushroom.EnumType.SOUTH_EAST;
                }
                case SOUTH_EAST: {
                    return BlockHugeMushroom.EnumType.SOUTH_WEST;
                }
                case SOUTH_WEST: {
                    return BlockHugeMushroom.EnumType.NORTH_WEST;
                }
                case NORTH: {
                    return BlockHugeMushroom.EnumType.EAST;
                }
                case EAST: {
                    return BlockHugeMushroom.EnumType.SOUTH;
                }
                case SOUTH: {
                    return BlockHugeMushroom.EnumType.WEST;
                }
                case WEST: {
                    return BlockHugeMushroom.EnumType.NORTH;
                }
            }
            return rotatedFacing;
        }
    }).build();

    public static float rotateFloatX(float x, float z, int turns) {
        float x1 = x;
        float z1 = z;
        for (int i = 0; i < turns; ++i) {
            z = x1;
            x1 = x = 1.0f - z1;
            z1 = z;
        }
        return x;
    }

    public static float rotateFloatZ(float x, float z, int turns) {
        float x1 = x;
        float z1 = z;
        for (int i = 0; i < turns; ++i) {
            z = x1;
            x1 = x = 1.0f - z1;
            z1 = z;
        }
        return z;
    }

    public static BlockPos getAverageOf(BlockPos ... positions) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        int count = 0;
        for (BlockPos pos : positions) {
            x += (float)pos.func_177958_n();
            y += (float)pos.func_177956_o();
            z += (float)pos.func_177952_p();
            ++count;
        }
        if (count > 0) {
            x /= (float)count;
            y /= (float)count;
            z /= (float)count;
        }
        return new BlockPos((double)x, (double)y, (double)z);
    }

    @Nullable
    public static BlockPos getBlockClickedOn(EntityPlayer player, World world, boolean offset) {
        float vectorZ;
        float vectorY;
        double reachLength;
        float var16;
        float rotPitch = player.field_70125_A;
        float rotYaw = player.field_70177_z;
        double testX = player.field_70165_t;
        double testY = player.field_70163_u + (double)player.func_70047_e();
        double testZ = player.field_70161_v;
        Vec3d testVector = new Vec3d(testX, testY, testZ);
        float var14 = MathHelper.func_76134_b((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float vectorX = var15 * (var16 = -MathHelper.func_76134_b((float)(-rotPitch * ((float)Math.PI / 180))));
        Vec3d testVectorFar = testVector.func_72441_c((double)vectorX * (reachLength = 5.0), (double)(vectorY = MathHelper.func_76126_a((float)(-rotPitch * ((float)Math.PI / 180)))) * reachLength, (double)(vectorZ = var14 * var16) * reachLength);
        RayTraceResult testHitPosition = world.func_72901_a(testVector, testVectorFar, true);
        if (testHitPosition == null) {
            return null;
        }
        Vec3d var25 = player.func_70676_i(1.0f);
        float var27 = 1.0f;
        List entitiesPossiblyHitByVector = world.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a(var25.field_72450_a * reachLength, var25.field_72448_b * reachLength, var25.field_72449_c * reachLength).func_72321_a((double)var27, (double)var27, (double)var27));
        for (Entity testEntity : entitiesPossiblyHitByVector) {
            if (!testEntity.func_70067_L()) continue;
            float bbExpansionSize = testEntity.func_70111_Y();
            AxisAlignedBB entityBB = testEntity.func_174813_aQ().func_72321_a((double)bbExpansionSize, (double)bbExpansionSize, (double)bbExpansionSize);
            if (!entityBB.func_72318_a(testVector)) continue;
            return new BlockPos(testEntity.field_70165_t, testEntity.field_70163_u, testEntity.field_70161_v);
        }
        return offset ? testHitPosition.func_178782_a().func_177972_a(testHitPosition.field_178784_b) : testHitPosition.func_178782_a();
    }

    public static BlockPos rotateAroundOrigin(BlockPos pos, int turns) {
        for (int i = 0; i < turns; ++i) {
            pos = BlockTools.rotateAroundOrigin(pos);
        }
        return pos;
    }

    private static BlockPos rotateAroundOrigin(BlockPos pos) {
        return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
    }

    public static boolean isPositionWithinBounds(BlockPos test, BlockPos pos1, BlockPos pos2) {
        return test.func_177958_n() >= pos1.func_177958_n() && test.func_177958_n() <= pos2.func_177958_n() && test.func_177956_o() >= pos1.func_177956_o() && test.func_177956_o() <= pos2.func_177956_o() && test.func_177952_p() >= pos1.func_177952_p() && test.func_177952_p() <= pos2.func_177952_p();
    }

    public static BlockPos getMin(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static BlockPos getMax(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static BlockPos rotateInArea(BlockPos pos, int xSize, int zSize, int turns) {
        int xSize1 = xSize;
        int zSize1 = zSize;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        if (x >= xSize) {
            x = 0;
        }
        if (z >= zSize) {
            z = 0;
        }
        int x1 = x;
        int z1 = z;
        int positiveTurns = turns > 0 ? turns : 4 + turns;
        for (int i = 0; i < positiveTurns; ++i) {
            x = zSize - 1 - z1;
            z = x1;
            x1 = x;
            z1 = z;
            xSize = zSize1;
            zSize = xSize1;
            xSize1 = xSize;
            zSize1 = zSize;
        }
        return new BlockPos(x, pos.func_177956_o(), z);
    }

    public static boolean breakBlockAndDrop(World world, BlockPos pos) {
        return BlockTools.breakBlock(world, pos, 0, true);
    }

    public static boolean breakBlock(World world, BlockPos pos, int fortune, boolean doDrop) {
        if (world.field_72995_K) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos) || state.func_185887_b(world, pos) < 0.0f) {
            return false;
        }
        if (doDrop) {
            if (!BlockTools.canBreakBlock(world, pos, state)) {
                return false;
            }
            block.func_176226_b(world, pos, state, fortune);
        }
        return world.func_175698_g(pos);
    }

    private static boolean canBreakBlock(World world, BlockPos pos, IBlockState state) {
        return !AWCoreStatics.fireBlockBreakEvents || !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)AWFakePlayer.get(world)));
    }

    public static boolean breakBlockNoDrops(World world, BlockPos pos, IBlockState state) {
        if (!BlockTools.canBreakBlock(world, pos, state) || !world.func_175698_g(pos)) {
            return false;
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        return true;
    }

    public static boolean placeItemBlockRightClick(ItemStack stack, World world, BlockPos pos) {
        AWFakePlayer owner = AWFakePlayer.get(world);
        owner.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        owner.func_184611_a(EnumHand.MAIN_HAND, stack);
        ((EntityPlayer)owner).field_70125_A = 90.0f;
        return stack.func_77957_a(world, (EntityPlayer)owner, EnumHand.MAIN_HAND).func_188397_a() == EnumActionResult.SUCCESS;
    }

    public static boolean placeItemBlock(ItemStack stack, World world, BlockPos pos, EnumFacing face) {
        EnumFacing direction = face.func_176734_d();
        AWFakePlayer owner = AWFakePlayer.get(world);
        owner.func_184611_a(EnumHand.MAIN_HAND, stack);
        return stack.func_179546_a((EntityPlayer)owner, world, pos.func_177972_a(direction), EnumHand.MAIN_HAND, face, 0.25f, 0.25f, 0.25f) == EnumActionResult.SUCCESS;
    }

    public static void notifyBlockUpdate(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
    }

    public static void notifyBlockUpdate(TileEntity tile) {
        BlockTools.notifyBlockUpdate(tile.func_145831_w(), tile.func_174877_v());
    }

    public static JsonElement serializeToJson(IBlockState state) {
        JsonObject serializedState = new JsonObject();
        serializedState.addProperty("name", state.func_177230_c().getRegistryName().toString());
        JsonObject serializedProps = new JsonObject();
        for (Map.Entry prop : state.func_177228_b().entrySet()) {
            serializedProps.addProperty(((IProperty)prop.getKey()).func_177701_a(), BlockTools.serializeValue((IProperty)prop.getKey(), (Comparable)prop.getValue()));
        }
        if (!serializedProps.entrySet().isEmpty()) {
            serializedState.add("properties", (JsonElement)serializedProps);
        }
        return serializedState;
    }

    private static <T extends Comparable<T>> String serializeValue(IProperty<T> property, Comparable<?> valueString) {
        return property.func_177702_a(valueString);
    }

    public static EnumFacing getHorizontalFacingFromMeta(int meta) {
        return EnumFacing.field_82609_l[meta].func_176740_k() != EnumFacing.Axis.Y ? EnumFacing.field_82609_l[meta] : EnumFacing.NORTH;
    }

    public static <T> T getBlockState(Tuple<String, Map<String, String>> blockProps, Function<Block, T> init, AddPropertyFunction<T> addProperty) {
        String registryName = (String)blockProps.func_76341_a();
        Map properties = (Map)blockProps.func_76340_b();
        Block block = RegistryTools.getBlock(registryName);
        T ret = init.apply(block);
        BlockStateContainer stateContainer = block.func_176194_O();
        for (Map.Entry prop : properties.entrySet()) {
            IProperty property = stateContainer.func_185920_a((String)prop.getKey());
            if (property == null) {
                throw new MissingResourceException("Block \"" + block.getRegistryName().toString() + "\" doesn't have \"" + (String)prop.getKey() + "\" property", IProperty.class.getName(), (String)prop.getKey());
            }
            ret = addProperty.apply(ret, (IProperty<?>)property, (Comparable<?>)BlockTools.getPropertyState(block, stateContainer, (String)prop.getKey(), (String)prop.getValue()).getValue());
        }
        return ret;
    }

    public static <T extends Comparable<T>> IBlockState updateProperty(IBlockState state, IProperty<T> property, Comparable<?> value) {
        return state.func_177226_a(property, value);
    }

    private static <T extends Comparable<T>> Optional<T> getValueHelper(IProperty<T> property, String valueString) {
        return BlockTools.toJUtilOptional(property.func_185929_b(valueString));
    }

    private static <T> Optional<T> toJUtilOptional(com.google.common.base.Optional<T> optional) {
        return (Optional)optional.transform(Optional::of).or(Optional::empty);
    }

    public static IBlockState rotateFacing(IBlockState state, int turns) {
        for (Map.Entry property : state.func_177228_b().entrySet()) {
            Class valueClass = ((IProperty)property.getKey()).func_177699_b();
            if (!ROTATORS.containsKey(valueClass)) continue;
            state = BlockTools.rotateY(state, (IProperty)property.getKey(), turns);
        }
        return state;
    }

    private static <T extends Comparable<T>> IBlockState rotateY(IBlockState state, IProperty<T> property, int turns) {
        return state.func_177226_a(property, ROTATORS.get(property.func_177699_b()).rotateY(state.func_177229_b(property), turns));
    }

    public static PropertyState getPropertyState(Block block, BlockStateContainer stateContainer, String propName, String propValue) {
        IProperty property = stateContainer.func_185920_a(propName);
        if (property == null) {
            throw new MissingResourceException("Block \"" + block.getRegistryName().toString() + "\" doesn't have \"" + propName + "\" property", IProperty.class.getName(), propName);
        }
        return BlockTools.getPropertyState(property, propName, propValue);
    }

    private static <T extends Comparable<T>, V extends T> PropertyState<T, V> getPropertyState(IProperty<T> property, String propName, String propValue) {
        Optional<T> value = BlockTools.getValueHelper(property, propValue);
        if (!value.isPresent()) {
            throw new MissingResourceException("Invalid value \"" + propValue + "\" for property \"" + propName + "\"", IProperty.class.getName(), propName);
        }
        return new PropertyState<T, Comparable>(property, (Comparable)value.get());
    }

    public static int getTopFilledHeight(World world, int x, int z, boolean skippables, int maxY) {
        return BlockTools.getTopFilledHeight(world.func_72964_e(x >> 4, z >> 4), x, z, skippables, maxY);
    }

    public static int getTopFilledHeight(World world, int x, int z, boolean skippables) {
        return BlockTools.getTopFilledHeight(world.func_72964_e(x >> 4, z >> 4), x, z, skippables);
    }

    public static int getTopFilledHeight(Chunk chunk, int x, int z, boolean skippables) {
        return BlockTools.getTopFilledHeight(chunk, x, z, skippables, chunk.func_76625_h() + 16);
    }

    private static int getTopFilledHeight(Chunk chunk, int x, int z, boolean skippables, int maxY) {
        for (int y = maxY; y > 0; --y) {
            IBlockState state = chunk.func_177435_g(new BlockPos(x, y, z));
            Block block = state.func_177230_c();
            if (block == Blocks.field_150350_a || skippables && AWStructureStatics.isSkippable(state)) continue;
            return y;
        }
        return -1;
    }

    public static Iterable<BlockPos> getAllInBoxTopDown(BlockPos from, BlockPos to) {
        return BlockTools.getAllInBoxTopDown(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()), Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
    }

    public static Iterable<BlockPos> getAllInBoxTopDown(final int x1, final int y1, final int z1, final int x2, final int y2, final int z2) {
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private boolean first = true;
                    private int lastPosX;
                    private int lastPosY;
                    private int lastPosZ;

                    protected BlockPos computeNext() {
                        if (this.first) {
                            this.first = false;
                            this.lastPosX = x1;
                            this.lastPosY = y2;
                            this.lastPosZ = z1;
                            return new BlockPos(x1, y2, z1);
                        }
                        if (this.lastPosX == x2 && this.lastPosY == y1 && this.lastPosZ == z2) {
                            return (BlockPos)this.endOfData();
                        }
                        if (this.lastPosX < x2) {
                            ++this.lastPosX;
                        } else if (this.lastPosZ < z2) {
                            this.lastPosX = x1;
                            ++this.lastPosZ;
                        } else if (this.lastPosY > y1) {
                            this.lastPosX = x1;
                            this.lastPosZ = z1;
                            --this.lastPosY;
                        }
                        return new BlockPos(this.lastPosX, this.lastPosY, this.lastPosZ);
                    }
                };
            }
        };
    }

    public static interface AddPropertyFunction<T> {
        public T apply(T var1, IProperty<?> var2, Comparable<?> var3);
    }

    private static interface IRotator<T extends Comparable<T>> {
        public T rotateY(T var1, int var2);
    }
}

