/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import com.google.common.primitives.Floats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttack;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIPlayerOwnedAttackRanged
extends NpcAIAttack<NpcBase> {
    private final IRangedAttackMob rangedAttacker;
    private double attackDistance = AWNPCStatics.archerRange * AWNPCStatics.archerRange;

    public NpcAIPlayerOwnedAttackRanged(NpcBase npc) {
        super(npc);
        this.rangedAttacker = (IRangedAttackMob)npc;
        this.moveSpeed = 1.0;
        this.func_75248_a(3);
    }

    @Override
    protected boolean shouldCloseOnTarget(double dist) {
        if (this.npc.doNotPursue) {
            return dist < 0.0;
        }
        return dist > this.attackDistance || !this.npc.func_70635_at().func_75522_a((Entity)this.getTarget());
    }

    @Override
    protected void doAttack(double dist) {
        this.npc.removeAITask(512);
        this.npc.func_70661_as().func_75499_g();
        if (this.getAttackDelay() <= 0) {
            float pwr = (float)(this.attackDistance / dist);
            pwr = Floats.constrainToRange((float)pwr, (float)0.1f, (float)1.0f);
            this.rangedAttacker.func_82196_d(this.getTarget(), pwr);
            this.setAttackDelay(35);
        }
    }
}

