/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.command;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.npc.faction.FactionTracker;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;

public class CommandFaction
extends CommandBase {
    private static final String COMMAND_AW_FACTION_SET_USAGE_UNLOC = "command.aw.faction.set.usage";

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "awfaction";
    }

    public String func_71518_a(ICommandSender var1) {
        return "command.aw.faction.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender var1, String[] var2) throws CommandException {
        block11: {
            String playerName;
            String cmd;
            block12: {
                int amt;
                block10: {
                    if (var2.length < 2) {
                        throw new WrongUsageException(this.func_71518_a(var1), new Object[0]);
                    }
                    cmd = var2[0];
                    playerName = var2[1];
                    if (!cmd.equalsIgnoreCase("set")) break block10;
                    if (var2.length < 4) {
                        throw new WrongUsageException(COMMAND_AW_FACTION_SET_USAGE_UNLOC, new Object[0]);
                    }
                    String faction = var2[2];
                    if (FactionRegistry.getFactionNames().stream().noneMatch(f -> f.equalsIgnoreCase(faction))) {
                        throw new WrongUsageException(COMMAND_AW_FACTION_SET_USAGE_UNLOC, new Object[0]);
                    }
                    String amount = var2[3];
                    int amt2 = 0;
                    try {
                        amt2 = Integer.parseInt(amount);
                    }
                    catch (NumberFormatException e) {
                        throw new WrongUsageException(COMMAND_AW_FACTION_SET_USAGE_UNLOC, new Object[0]);
                    }
                    FactionTracker.INSTANCE.setStandingFor(var1.func_130014_f_(), playerName, faction, amt2);
                    var1.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.faction.set", new Object[]{playerName, faction, amt2}));
                    break block11;
                }
                if (!cmd.equalsIgnoreCase("setall")) break block12;
                if (var2.length < 3) {
                    throw new WrongUsageException("command.aw.faction.setall.usage", new Object[0]);
                }
                String amount = var2[2];
                try {
                    amt = Integer.parseInt(amount);
                }
                catch (NumberFormatException e) {
                    throw new WrongUsageException("command.aw.faction.setall.usage", new Object[0]);
                }
                for (String faction : FactionRegistry.getFactionNames()) {
                    FactionTracker.INSTANCE.setStandingFor(var1.func_130014_f_(), playerName, faction, amt);
                    var1.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.faction.set", new Object[]{playerName, faction, amt}));
                }
                break block11;
            }
            if (!cmd.equalsIgnoreCase("get")) break block11;
            World world = var1.func_130014_f_();
            var1.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.faction.status.player", new Object[]{playerName}));
            for (String faction : FactionRegistry.getFactionNames()) {
                int standing = FactionTracker.INSTANCE.getStandingFor(world, playerName, faction);
                var1.func_145747_a((ITextComponent)new TextComponentTranslation("command.aw.faction.status.value", new Object[]{faction, standing}));
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"set", "setall", "get"});
        }
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("set")) {
                return CommandBase.func_175762_a((String[])args, FactionRegistry.getFactionNames());
            }
        } else if (args.length == 4) {
            // empty if block
        }
        return null;
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return var2 == 1;
    }
}

