/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBase;
import net.shadowmage.ancientwarfare.npc.container.ISkinSettingsContainer;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinSettings;

public class ContainerNpcCreativeControls
extends ContainerNpcBase<NpcBase>
implements ISkinSettingsContainer {
    public String ownerName;
    public boolean wander;
    public int maxHealth;
    public int attackDamage;
    public int armorValue;
    public NpcSkinSettings skinSettings;
    private boolean hasChanged;

    public ContainerNpcCreativeControls(EntityPlayer player, int x, int y, int z) {
        super(player, x);
        this.ownerName = ((NpcBase)this.entity).getOwner().getName();
        this.skinSettings = ((NpcBase)this.entity).getSkinSettings();
        this.wander = ((NpcBase)this.entity).getIsAIEnabled();
        this.maxHealth = ((NpcBase)this.entity).getMaxHealthOverride();
        this.attackDamage = ((NpcBase)this.entity).getAttackDamageOverride();
        this.armorValue = ((NpcBase)this.entity).getArmorValueOverride();
    }

    public void sendChangesToServer() {
        this.sendDataToServer(this.serializeContainerData());
    }

    private NBTTagCompound serializeContainerData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("ownerName", this.ownerName);
        tag.func_74782_a("skinSettings", (NBTBase)this.skinSettings.serializeNBT());
        tag.func_74757_a("wander", this.wander);
        tag.func_74768_a("maxHealth", this.maxHealth);
        tag.func_74768_a("attackDamage", this.attackDamage);
        tag.func_74768_a("armorValue", this.armorValue);
        return tag;
    }

    @Override
    public void sendInitData() {
        this.sendDataToClient(this.serializeContainerData());
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        this.ownerName = tag.func_74779_i("ownerName");
        this.wander = tag.func_74767_n("wander");
        this.attackDamage = tag.func_74762_e("attackDamage");
        this.armorValue = tag.func_74762_e("armorValue");
        this.maxHealth = tag.func_74762_e("maxHealth");
        this.skinSettings = NpcSkinSettings.deserializeNBT(tag.func_74775_l("skinSettings"));
        this.hasChanged = true;
        this.refreshGui();
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        if (this.hasChanged && !this.player.field_70170_p.field_72995_K) {
            this.hasChanged = false;
            ((NpcBase)this.entity).setOwnerName(this.ownerName);
            ((NpcBase)this.entity).setSkinSettings(this.skinSettings.minimizeData());
            ((NpcBase)this.entity).setAttackDamageOverride(this.attackDamage);
            ((NpcBase)this.entity).setArmorValueOverride(this.armorValue);
            ((NpcBase)this.entity).setIsAIEnabled(this.wander);
            ((NpcBase)this.entity).setMaxHealthOverride(this.maxHealth);
        }
        super.func_75134_a(par1EntityPlayer);
    }

    @Override
    public void handleNpcSkinUpdate() {
        this.sendDataToServer("skinSettings", (NBTBase)this.skinSettings.serializeNBT());
    }

    @Override
    public NpcSkinSettings getSkinSettings() {
        return this.skinSettings;
    }

    @Override
    public void setSkinSettings(NpcSkinSettings skinSettings) {
        this.skinSettings = skinSettings;
    }
}

