/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.core.init.AWCoreItems;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcTrader;
import net.shadowmage.ancientwarfare.npc.trade.POTradeList;

public class ContainerNpcPlayerOwnedTrade
extends ContainerNpcBase<NpcTrader> {
    private EnumHand hand;
    public POTradeList tradeList;
    public final IItemHandler storage;

    public ContainerNpcPlayerOwnedTrade(EntityPlayer player, int x, int y, int z) {
        super(player, x);
        this.tradeList = ((NpcTrader)this.entity).getTradeList();
        ((NpcTrader)this.entity).startTrade(player);
        this.addPlayerSlots();
        this.hand = EntityTools.getHandHoldingItem((EntityLivingBase)this.entity, AWCoreItems.BACKPACK);
        IItemHandler iItemHandler = this.storage = this.hand != null ? (IItemHandler)((NpcTrader)this.entity).func_184586_b(this.hand).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) : null;
        if (this.storage != null) {
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                this.func_75146_a((Slot)new SlotItemHandler(this.storage, i, 100000, 100000));
            }
        }
    }

    @Override
    public void sendInitData() {
        if (this.tradeList != null) {
            NBTTagCompound packetTag = new NBTTagCompound();
            packetTag.func_74782_a("tradeData", (NBTBase)this.tradeList.serializeNBT());
            this.sendDataToClient(packetTag);
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("tradeData")) {
            this.tradeList = new POTradeList();
            this.tradeList.deserializeNBT(tag.func_74775_l("tradeData"));
        } else if (tag.func_74764_b("doTrade")) {
            this.tradeList.performTrade(this.player, this.storage, tag.func_74762_e("doTrade"));
        }
        this.refreshGui();
    }

    public void func_75134_a(EntityPlayer player) {
        ((NpcTrader)this.entity).closeTrade();
        super.func_75134_a(player);
    }

    public void doTrade(int tradeIndex) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("doTrade", tradeIndex);
        this.sendDataToServer(tag);
    }
}

