/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.event;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.util.TextUtils;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.tile.ISpecialLootContainer;
import net.shadowmage.ancientwarfare.structure.tile.TileProtectionFlag;
import org.apache.commons.lang3.StringUtils;

public class EventHandler {
    private Set<Predicate<EntityAIBase>> additionalHostileAIChecks = new HashSet<Predicate<EntityAIBase>>();
    public static final EventHandler INSTANCE = new EventHandler();

    private EventHandler() {
    }

    public void registerAdditionalHostileAICheck(Predicate<EntityAIBase> aiCheck) {
        this.additionalHostileAIChecks.add(aiCheck);
    }

    private int getHostileAIPriority(EntityCreature entity) {
        for (EntityAITasks.EntityAITaskEntry taskEntry : entity.field_70715_bh.field_75782_a) {
            if ((!(taskEntry.field_75733_a instanceof EntityAINearestAttackableTarget) || ((EntityAINearestAttackableTarget)taskEntry.field_75733_a).field_75307_b != EntityPlayer.class) && !this.anyAdditionalHostileAIChecksMatch(taskEntry) || taskEntry.field_75731_b == -1) continue;
            return taskEntry.field_75731_b;
        }
        return -1;
    }

    private boolean anyAdditionalHostileAIChecksMatch(EntityAITasks.EntityAITaskEntry taskEntry) {
        for (Predicate<EntityAIBase> additionalCheck : this.additionalHostileAIChecks) {
            if (!additionalCheck.test(taskEntry.field_75733_a)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof NpcBase) {
            return;
        }
        if (!(event.getEntity() instanceof EntityCreature)) {
            return;
        }
        EntityCreature entity = (EntityCreature)event.getEntity();
        int targetTaskPriority = this.getHostileAIPriority(entity);
        if (targetTaskPriority != -1) {
            entity.field_70715_bh.func_75776_a(targetTaskPriority, (EntityAIBase)new EntityAINearestAttackableTarget(entity, NpcBase.class, 0, true, false, e -> this.entityShouldTarget(entity, (NpcBase)e)));
        }
    }

    private boolean entityShouldTarget(EntityCreature entity, @Nullable NpcBase e) {
        if (e == null) {
            return false;
        }
        if (e instanceof NpcFaction && !e.isPassive() && FactionRegistry.getFaction(((NpcFaction)e).getFaction()).isTarget((Entity)entity)) {
            return true;
        }
        return e instanceof NpcPlayerOwned && NpcDefaultsRegistry.getOwnedNpcDefault((NpcPlayerOwned)e).isTarget((Entity)entity);
    }

    @SubscribeEvent
    public void onChestClicked(PlayerInteractEvent.RightClickBlock evt) {
        World world = evt.getWorld();
        BlockPos pos = evt.getPos();
        EntityPlayer player = evt.getEntityPlayer();
        if (!player.field_71075_bZ.field_75098_d && this.isContainer(world, pos)) {
            AWGameData.INSTANCE.getData(world, StructureMap.class).getStructureAt(world, pos).ifPresent(structure -> {
                Optional<TileProtectionFlag> tile = WorldTools.getTile((IBlockAccess)world, structure.getProtectionFlagPos(), TileProtectionFlag.class);
                if (tile.isPresent() && tile.get().shouldProtectAgainst(player)) {
                    evt.setCanceled(true);
                    evt.setCancellationResult(EnumActionResult.FAIL);
                    if (world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarenpc.no_chest_access_flag_not_claimed", new Object[]{TextUtils.getSimpleBlockPosString(structure.getProtectionFlagPos())}), true);
                    }
                } else {
                    for (NpcFaction factionNpc : world.func_72872_a(NpcFaction.class, structure.getBB().getAABB())) {
                        if (factionNpc.isPassive()) continue;
                        evt.setCanceled(true);
                        evt.setCancellationResult(EnumActionResult.FAIL);
                        factionNpc.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 100));
                        if (world.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarenpc.no_chest_access", new Object[]{StringUtils.capitalize((String)factionNpc.getFaction())}), true);
                        }
                        return;
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void playerDigSpeed(PlayerEvent.BreakSpeed evt) {
        if (evt.getEntityPlayer().func_184812_l_() || evt.getEntityPlayer().func_175149_v()) {
            return;
        }
        World world = evt.getEntityPlayer().field_70170_p;
        AWGameData.INSTANCE.getData(world, StructureMap.class).getStructureAt(world, evt.getPos()).ifPresent(structureEntry -> WorldTools.getTile((IBlockAccess)world, structureEntry.getProtectionFlagPos(), TileProtectionFlag.class).ifPresent(tile -> {
            if (tile.shouldProtectAgainst(evt.getEntityPlayer()) && this.shouldBlockSlowDownDigging(world, evt.getPos())) {
                evt.setNewSpeed(evt.getOriginalSpeed() * 0.01f);
            }
        }));
    }

    private boolean shouldBlockSlowDownDigging(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_185913_b()) {
            return this.isContainer(world, pos);
        }
        Block block = state.func_177230_c();
        return block != Blocks.field_150474_ac && block != AWStructureBlocks.ADVANCED_SPAWNER;
    }

    private boolean isContainer(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block == Blocks.field_150486_ae || state.func_177230_c().hasTileEntity(state) && WorldTools.getTile((IBlockAccess)world, pos, ISpecialLootContainer.class).isPresent();
    }
}

