/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.init;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.shadowmage.ancientwarfare.core.entity.AWEntityRegistry;
import net.shadowmage.ancientwarfare.core.init.AWCoreItems;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.entity.NpcBard;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.NpcCombat;
import net.shadowmage.ancientwarfare.npc.entity.NpcCourier;
import net.shadowmage.ancientwarfare.npc.entity.NpcPriest;
import net.shadowmage.ancientwarfare.npc.entity.NpcTrader;
import net.shadowmage.ancientwarfare.npc.entity.NpcWorker;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionArcherElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionBard;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionCivilianFemale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionCivilianMale;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionLeader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionLeaderElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionMountedArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionMountedSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionPriest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionSiegeEngineer;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionSoldier;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionSoldierElite;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionTrader;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.NpcSiegeEngineer;
import net.shadowmage.ancientwarfare.npc.init.AWNPCItems;

@Mod.EventBusSubscriber(modid="ancientwarfarenpc")
public class AWNPCEntities {
    private static final String COMBAT_TYPE = "combat";
    private static final String SOLDIER_SUBTYPE = "soldier";
    private static final String COMMANDER_SUBTYPE = "commander";
    private static final String ARCHER_SUBTYPE = "archer";
    private static final String WORKER_TYPE = "worker";
    private static final String MINER_SUBTYPE = "miner";
    private static int nextID = 0;
    private static final HashMap<String, NpcDeclaration> npcMap = new HashMap();

    private AWNPCEntities() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        AWNPCEntities.addPlayerOwnedNpcs();
        AWNPCEntities.addFaction();
    }

    private static void addPlayerOwnedNpcs() {
        NpcDeclaration reg = new NpcDeclaration(NpcCombat.class, "aw_npc_combat", COMBAT_TYPE, SOLDIER_SUBTYPE);
        reg.addSubTypes(new String[]{COMMANDER_SUBTYPE, SOLDIER_SUBTYPE, ARCHER_SUBTYPE, "medic", "engineer"});
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcDeclaration(NpcWorker.class, "aw_npc_worker", WORKER_TYPE, MINER_SUBTYPE);
        reg.addSubTypes(new String[]{MINER_SUBTYPE, "farmer", "lumberjack", "researcher", "craftsman"});
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcDeclaration(NpcCourier.class, "aw_npc_courier", "courier");
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcDeclaration(NpcTrader.class, "aw_npc_trader", "trader");
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcDeclaration(NpcPriest.class, "aw_npc_priest", "priest");
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcDeclaration(NpcBard.class, "aw_npc_bard", "bard");
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcDeclaration(NpcSiegeEngineer.class, "aw_npc_siege_engineer", "siege_engineer");
        AWNPCEntities.addNpcRegistration(reg);
    }

    private static void addFaction() {
        NpcFactionDeclaration reg = new NpcFactionDeclaration(NpcFactionArcher.class, "faction.archer", ARCHER_SUBTYPE);
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionSoldier.class, "faction.soldier", SOLDIER_SUBTYPE);
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionLeader.class, "faction.leader", COMMANDER_SUBTYPE);
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionPriest.class, "faction.priest", "priest");
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionTrader.class, "faction.trader", "trader");
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionMountedSoldier.class, "faction.cavalry", SOLDIER_SUBTYPE);
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionMountedArcher.class, "faction.mounted_archer", ARCHER_SUBTYPE);
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionCivilianMale.class, "faction.civilian.male", "civilian_male");
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionCivilianFemale.class, "faction.civilian.female", "civilian_female");
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionArcherElite.class, "faction.archer.elite", ARCHER_SUBTYPE);
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionSoldierElite.class, "faction.soldier.elite", SOLDIER_SUBTYPE);
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionLeaderElite.class, "faction.leader.elite", COMMANDER_SUBTYPE);
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionBard.class, "faction.bard", "bard");
        AWNPCEntities.addNpcRegistration(reg);
        reg = new NpcFactionDeclaration(NpcFactionSiegeEngineer.class, "faction.siege_engineer", "siege_engineer");
        AWNPCEntities.addNpcRegistration(reg);
    }

    public static void loadNpcSubtypeEquipment() {
        AWNPCEntities.addNpcSubtypeEquipment(WORKER_TYPE, "farmer", new ItemStack(Items.field_151019_K));
        AWNPCEntities.addNpcSubtypeEquipment(WORKER_TYPE, MINER_SUBTYPE, new ItemStack(Items.field_151035_b));
        AWNPCEntities.addNpcSubtypeEquipment(WORKER_TYPE, "lumberjack", new ItemStack(Items.field_151036_c));
        AWNPCEntities.addNpcSubtypeEquipment(WORKER_TYPE, "researcher", new ItemStack(AWCoreItems.IRON_QUILL));
        AWNPCEntities.addNpcSubtypeEquipment(WORKER_TYPE, "craftsman", new ItemStack(AWCoreItems.IRON_HAMMER));
        AWNPCEntities.addNpcSubtypeEquipment(COMBAT_TYPE, COMMANDER_SUBTYPE, new ItemStack((Item)AWNPCItems.IRON_COMMAND_BATON));
        AWNPCEntities.addNpcSubtypeEquipment(COMBAT_TYPE, SOLDIER_SUBTYPE, new ItemStack(Items.field_151040_l));
        AWNPCEntities.addNpcSubtypeEquipment(COMBAT_TYPE, ARCHER_SUBTYPE, new ItemStack((Item)Items.field_151031_f));
        AWNPCEntities.addNpcSubtypeEquipment(COMBAT_TYPE, "engineer", new ItemStack(AWCoreItems.IRON_HAMMER));
        AWNPCEntities.addNpcSubtypeEquipment(COMBAT_TYPE, "medic", new ItemStack(Items.field_151036_c));
    }

    private static void addNpcRegistration(NpcDeclaration reg) {
        AWEntityRegistry.registerEntity(reg);
        AWNPCEntities.getNpcMap().put(reg.getNpcType(), reg);
    }

    public static NpcBase createNpc(World world, String npcType, String npcSubtype, String faction) {
        if (!AWNPCEntities.getNpcMap().containsKey(npcType)) {
            return null;
        }
        NpcDeclaration reg = AWNPCEntities.getNpcMap().get(npcType);
        return reg.createEntity(world, npcSubtype, faction);
    }

    private static void addNpcSubtypeEquipment(String npcType, String npcSubtype, ItemStack equipment) {
        if (!AWNPCEntities.getNpcMap().containsKey(npcType)) {
            throw new IllegalArgumentException("npc type must first be mapped");
        }
        NpcDeclaration reg = AWNPCEntities.getNpcMap().get(npcType);
        reg.addSubtypeEquipment(npcSubtype, equipment);
    }

    public static Map<String, NpcDeclaration> getNpcMap() {
        return npcMap;
    }

    public static NpcDeclaration getNpcDeclaration(String npcType) {
        return npcMap.get(npcType);
    }

    public static class NpcFactionDeclaration
    extends NpcDeclaration {
        private NpcFactionDeclaration(Class<? extends NpcFaction> entityClass, String entityName, String itemModelVariant) {
            super(entityClass, entityName, entityName, itemModelVariant);
        }

        @Override
        public NpcFaction createEntity(World world, String subType, String factionName) {
            try {
                return (NpcFaction)this.getEntityClass().getConstructor(World.class, String.class).newInstance(world, factionName);
            }
            catch (Exception e) {
                AncientWarfareNPC.LOG.error("Couldn't create entity:" + e.getMessage());
                return null;
            }
        }
    }

    public static class NpcDeclaration
    extends AWEntityRegistry.EntityDeclaration {
        private final String itemModelVariant;
        private boolean spawnBaseEntity = true;
        private final String npcType;
        private final HashMap<String, ItemStack> spawnEquipment = new HashMap();

        public NpcDeclaration(Class<? extends Entity> entityClass, String entityName, String npcType) {
            this(entityClass, entityName, npcType, npcType.replace(".", "_"));
        }

        public NpcDeclaration(Class<? extends Entity> entityClass, String entityName, String npcType, String itemModelVariant) {
            super(entityClass, entityName, nextID++, "ancientwarfarenpc");
            this.npcType = npcType;
            this.itemModelVariant = itemModelVariant;
        }

        public String getFaction() {
            return "";
        }

        private void addSubTypes(String ... subTypes) {
            Arrays.stream(subTypes).forEach(s -> this.addSubtypeEquipment((String)s, ItemStack.field_190927_a));
        }

        private void addSubtypeEquipment(String type, ItemStack equipment) {
            this.spawnEquipment.put(type, equipment);
        }

        public NpcBase createEntity(World world, String subType, String factionName) {
            ItemStack stack;
            NpcBase npc = (NpcBase)this.createEntity(world);
            if (!subType.isEmpty() && !(stack = this.spawnEquipment.get(subType)).func_190926_b()) {
                npc.func_184201_a(EntityEquipmentSlot.MAINHAND, stack.func_77946_l());
            }
            return npc;
        }

        @Override
        public final Object mod() {
            return AncientWarfareNPC.instance;
        }

        @Override
        public final int trackingRange() {
            return 120;
        }

        @Override
        public final int updateFrequency() {
            return 3;
        }

        @Override
        public final boolean sendsVelocityUpdates() {
            return true;
        }

        public List<String> getItemModelVariants() {
            return new ImmutableList.Builder().addAll(this.spawnEquipment.keySet()).add((Object)this.itemModelVariant).build();
        }

        public String getItemModelVariant(String npcSubType) {
            if (npcSubType.isEmpty()) {
                return this.itemModelVariant;
            }
            return npcSubType;
        }

        public Set<String> getSubTypes() {
            return this.spawnEquipment.keySet();
        }

        public boolean canSpawnBaseEntity() {
            return this.spawnBaseEntity;
        }

        public String getNpcType() {
            return this.npcType;
        }
    }
}

