/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.npc.item.ItemOrders;
import net.shadowmage.ancientwarfare.npc.orders.TradeOrder;

public class ItemTradeOrder
extends ItemOrders {
    public ItemTradeOrder() {
        super("trade_order");
    }

    @Override
    public List<BlockPos> getPositionsForRender(ItemStack stack) {
        ArrayList<BlockPos> positionList = new ArrayList<BlockPos>();
        TradeOrder order = TradeOrder.getTradeOrder(stack);
        if (order != null && order.getRoute().size() > 0) {
            for (int i = 0; i < order.getRoute().size(); ++i) {
                positionList.add(order.getRoute().get(i).getPosition());
            }
        }
        return positionList;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1 || altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_2 || altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_3;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 6, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        RayTraceResult hit = RayTraceUtils.getPlayerTarget(player, 5.0f, 0.0f);
        if (hit == null || hit.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        TradeOrder order = TradeOrder.getTradeOrder(stack);
        if (altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1) {
            order.getRoute().addRoutePoint(hit.func_178782_a());
            order.write(stack);
        } else if (altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_2) {
            order.getRestockData().setDepositPoint(hit.func_178782_a(), hit.field_178784_b);
            order.write(stack);
        } else if (altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_3) {
            order.getRestockData().setWithdrawPoint(hit.func_178782_a(), hit.field_178784_b);
            order.write(stack);
        }
    }
}

