/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.npc.npc_command.NpcCommand;

public class PacketNpcCommand
extends PacketBase {
    private NpcCommand.CommandType type;
    private boolean blockTarget;
    private BlockPos pos;
    private int entityID;

    public PacketNpcCommand(NpcCommand.CommandType type, Entity ent) {
        this.type = type;
        this.blockTarget = false;
        this.entityID = ent.func_145782_y();
    }

    public PacketNpcCommand(NpcCommand.CommandType type, BlockPos pos) {
        this.type = type;
        this.blockTarget = true;
        this.pos = pos;
    }

    public PacketNpcCommand() {
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        data.writeInt(this.type.ordinal());
        data.writeBoolean(this.blockTarget);
        if (this.blockTarget) {
            data.writeLong(this.pos.func_177986_g());
        } else {
            data.writeInt(this.entityID);
        }
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        this.type = NpcCommand.CommandType.values()[data.readInt()];
        this.blockTarget = data.readBoolean();
        if (this.blockTarget) {
            this.pos = BlockPos.func_177969_a((long)data.readLong());
        } else {
            this.entityID = data.readInt();
        }
    }

    @Override
    protected void execute(EntityPlayer player) {
        NpcCommand.handleServerCommand(player, this.type, this.blockTarget, this.pos, this.entityID);
    }
}

