/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.npc_command;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;
import net.shadowmage.ancientwarfare.npc.network.PacketNpcCommand;

public class NpcCommand {
    public static void handleCommandClient(CommandType type, RayTraceResult hit) {
        if (hit != null && hit.field_72313_a != RayTraceResult.Type.MISS) {
            if (hit.field_72313_a == RayTraceResult.Type.ENTITY && hit.field_72308_g != null) {
                NetworkHandler.sendToServer(new PacketNpcCommand(type, hit.field_72308_g));
            } else if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                NetworkHandler.sendToServer(new PacketNpcCommand(type, hit.func_178782_a()));
            }
        }
    }

    public static void handleServerCommand(EntityPlayer player, CommandType type, boolean block, BlockPos pos, int entityID) {
        Command cmd = block ? new Command(type, pos) : new Command(type, entityID);
        List<Entity> targets = ItemCommandBaton.getCommandedEntities(player.field_70170_p, EntityTools.getItemFromEitherHand(player, ItemCommandBaton.class));
        for (Entity e : targets) {
            if (!(e instanceof NpcPlayerOwned)) continue;
            ((NpcPlayerOwned)e).handlePlayerCommand(cmd);
        }
    }

    public static final class Command {
        public CommandType type;
        public BlockPos pos = BlockPos.field_177992_a;
        public boolean blockTarget;
        UUID entityUUID;
        int entityID;
        Entity entity;

        public Command() {
        }

        public Command(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        public Command(CommandType type, BlockPos pos) {
            this.type = type;
            this.pos = pos;
            this.blockTarget = true;
        }

        public Command(CommandType type, int entityID) {
            this.type = type;
            this.entityID = entityID;
            this.blockTarget = false;
        }

        public Command copy() {
            Command cmd = new Command();
            cmd.type = this.type;
            cmd.pos = this.pos;
            cmd.entity = this.entity;
            cmd.entityID = this.entityID;
            cmd.entityUUID = this.entityUUID;
            cmd.blockTarget = this.blockTarget;
            return cmd;
        }

        public final void readFromNBT(NBTTagCompound tag) {
            this.type = CommandType.values()[tag.func_74762_e("type")];
            this.blockTarget = tag.func_74767_n("block");
            this.pos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
            if (tag.func_74764_b("idmsb") && tag.func_74764_b("idlsb")) {
                this.entityUUID = new UUID(tag.func_74763_f("idmsb"), tag.func_74763_f("idlsb"));
            }
            this.entityID = tag.func_74762_e("entityid");
        }

        public final NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("type", this.type.ordinal());
            tag.func_74757_a("block", this.blockTarget);
            tag.func_74772_a("pos", this.pos.func_177986_g());
            if (this.entityUUID != null) {
                tag.func_74772_a("idmsb", this.entityUUID.getMostSignificantBits());
                tag.func_74772_a("idlsb", this.entityUUID.getLeastSignificantBits());
            }
            tag.func_74768_a("entityid", this.entityID);
            return tag;
        }

        public void findEntity(World world) {
            if (this.blockTarget) {
                return;
            }
            if (this.entity != null) {
                return;
            }
            if (this.entityUUID == null) {
                this.entity = world.func_73045_a(this.entityID);
                if (this.entity != null) {
                    this.entityUUID = this.entity.getPersistentID();
                }
            } else {
                this.entity = world.func_152378_a(this.entityUUID);
            }
        }

        public Entity getEntityTarget(World world) {
            if (this.blockTarget) {
                return null;
            }
            if (this.entity != null) {
                return this.entity;
            }
            this.findEntity(world);
            return this.entity;
        }
    }

    public static enum CommandType {
        MOVE,
        ATTACK,
        ATTACK_AREA,
        GUARD,
        SET_HOME,
        SET_UPKEEP,
        CLEAR_HOME,
        CLEAR_UPKEEP,
        CLEAR_COMMAND;


        public boolean isPersistent() {
            return this == ATTACK || this == GUARD || this == ATTACK_AREA;
        }
    }
}

