/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.orders;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.block.BlockTownHall;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.item.ItemUpkeepOrder;

public class UpkeepOrder
implements INBTSerializable<NBTTagCompound> {
    private static final String UPKEEP_POSITION_TAG = "upkeepPosition";
    private static final String ORDERS_TAG = "orders";
    private BlockPos upkeepPosition;
    private int upkeepDimension;
    private EnumFacing blockSide = EnumFacing.DOWN;
    private int upkeepAmount = 6000;

    public void changeBlockSide() {
        this.blockSide = EnumFacing.field_82609_l[(this.blockSide.ordinal() + 1) % EnumFacing.field_82609_l.length];
    }

    public void removeUpkeepPoint() {
        this.upkeepPosition = null;
        this.blockSide = EnumFacing.DOWN;
        this.upkeepDimension = 0;
        this.upkeepAmount = 6000;
    }

    public void setUpkeepAmount(int amt) {
        this.upkeepAmount = amt;
    }

    public EnumFacing getUpkeepBlockSide() {
        return this.blockSide;
    }

    public int getUpkeepDimension() {
        return this.upkeepDimension;
    }

    public Optional<BlockPos> getUpkeepPosition() {
        return Optional.ofNullable(this.upkeepPosition);
    }

    public final int getUpkeepAmount() {
        return this.upkeepAmount;
    }

    public boolean addUpkeepPosition(World world, BlockPos pos) {
        if (WorldTools.getTile((IBlockAccess)world, pos, TileEntity.class).map(InventoryTools::isInventory).orElse(false).booleanValue()) {
            if (!AWNPCStatics.npcAllowUpkeepAnyInventory && !(world.func_180495_p(pos).func_177230_c() instanceof BlockTownHall)) {
                return false;
            }
            this.upkeepPosition = pos;
            this.upkeepDimension = world.field_73011_w.getDimension();
            this.blockSide = EnumFacing.DOWN;
            this.upkeepAmount = 6000;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Upkeep Orders[" + this.upkeepPosition + "]";
    }

    public static Optional<UpkeepOrder> getUpkeepOrder(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemUpkeepOrder) {
            UpkeepOrder order = new UpkeepOrder();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ORDERS_TAG)) {
                order.deserializeNBT(stack.func_77978_p().func_74775_l(ORDERS_TAG));
            }
            return Optional.of(order);
        }
        return Optional.empty();
    }

    public void write(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemUpkeepOrder) {
            stack.func_77983_a(ORDERS_TAG, (NBTBase)this.serializeNBT());
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.getUpkeepPosition().isPresent()) {
            tag.func_74772_a(UPKEEP_POSITION_TAG, this.upkeepPosition.func_177986_g());
            tag.func_74768_a("dim", this.upkeepDimension);
            tag.func_74774_a("side", (byte)this.blockSide.ordinal());
            tag.func_74768_a("upkeepAmount", this.upkeepAmount);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b(UPKEEP_POSITION_TAG)) {
            this.upkeepPosition = BlockPos.func_177969_a((long)tag.func_74763_f(UPKEEP_POSITION_TAG));
            this.upkeepDimension = tag.func_74762_e("dim");
            this.blockSide = EnumFacing.field_82609_l[tag.func_74771_c("side")];
            this.upkeepAmount = tag.func_74762_e("upkeepAmount");
        }
    }
}

