/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.proxy;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.config.ConfigManager;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.proxy.IClientRegister;
import net.shadowmage.ancientwarfare.core.util.TextureImageBased;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.client.NPCItemColors;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.gui.GuiCombatOrder;
import net.shadowmage.ancientwarfare.npc.gui.GuiNpcBard;
import net.shadowmage.ancientwarfare.npc.gui.GuiNpcCreativeControls;
import net.shadowmage.ancientwarfare.npc.gui.GuiNpcFactionBard;
import net.shadowmage.ancientwarfare.npc.gui.GuiNpcFactionTradeSetup;
import net.shadowmage.ancientwarfare.npc.gui.GuiNpcFactionTradeView;
import net.shadowmage.ancientwarfare.npc.gui.GuiNpcInventory;
import net.shadowmage.ancientwarfare.npc.gui.GuiNpcPlayerOwnedTrade;
import net.shadowmage.ancientwarfare.npc.gui.GuiRoutingOrder;
import net.shadowmage.ancientwarfare.npc.gui.GuiTownHallInventory;
import net.shadowmage.ancientwarfare.npc.gui.GuiTradeOrder;
import net.shadowmage.ancientwarfare.npc.gui.GuiUpkeepOrder;
import net.shadowmage.ancientwarfare.npc.gui.GuiWorkOrder;
import net.shadowmage.ancientwarfare.npc.item.IExtendedReachWeapon;
import net.shadowmage.ancientwarfare.npc.proxy.NpcCommonProxy;
import net.shadowmage.ancientwarfare.npc.render.RenderCommandOverlay;
import net.shadowmage.ancientwarfare.npc.render.RenderNpcBase;
import net.shadowmage.ancientwarfare.npc.render.RenderNpcFaction;
import net.shadowmage.ancientwarfare.npc.render.RenderWorkLines;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinManager;

@SideOnly(value=Side.CLIENT)
public class NpcClientProxy
extends NpcCommonProxy {
    private Set<IClientRegister> clientRegisters = Sets.newHashSet();

    public NpcClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (IClientRegister register : this.clientRegisters) {
            register.registerClient();
        }
    }

    @Override
    public void addClientRegister(IClientRegister register) {
        this.clientRegisters.add(register);
    }

    @Override
    public void preInit() {
        super.preInit();
        NetworkHandler.registerGui(4, GuiNpcInventory.class);
        NetworkHandler.registerGui(39, GuiNpcFactionTradeSetup.class);
        NetworkHandler.registerGui(42, GuiNpcFactionTradeView.class);
        NetworkHandler.registerGui(34, GuiWorkOrder.class);
        NetworkHandler.registerGui(35, GuiUpkeepOrder.class);
        NetworkHandler.registerGui(36, GuiCombatOrder.class);
        NetworkHandler.registerGui(37, GuiRoutingOrder.class);
        NetworkHandler.registerGui(41, GuiTownHallInventory.class);
        NetworkHandler.registerGui(43, GuiNpcBard.class);
        NetworkHandler.registerGui(44, GuiNpcCreativeControls.class);
        NetworkHandler.registerGui(6, GuiTradeOrder.class);
        NetworkHandler.registerGui(47, GuiNpcPlayerOwnedTrade.class);
        NetworkHandler.registerGui(49, GuiNpcFactionBard.class);
        RenderingRegistry.registerEntityRenderingHandler(NpcBase.class, RenderNpcBase::new);
        RenderingRegistry.registerEntityRenderingHandler(NpcFaction.class, RenderNpcFaction::new);
        MinecraftForge.EVENT_BUS.register((Object)RenderWorkLines.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RenderCommandOverlay.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new IExtendedReachWeapon.MouseClickHandler());
        this.registerClientOptions();
    }

    @Override
    public void init() {
        super.init();
        NPCItemColors.init();
    }

    private void registerClientOptions() {
        ConfigManager.registerConfigCategory((IConfigElement)new NpcCategory("awconfig.npc_config"));
    }

    @Override
    public void loadSkins() {
        NpcSkinManager.loadSkins();
    }

    @Override
    public Optional<ResourceLocation> loadSkinPackImage(String imageName, InputStream is) {
        try {
            BufferedImage image = ImageIO.read(is);
            ResourceLocation loc = new ResourceLocation("ancientwarfare:skinpack/" + imageName);
            TextureImageBased tex = new TextureImageBased(loc, image);
            Minecraft.func_71410_x().field_71446_o.func_110579_a(loc, (ITextureObject)tex);
            return Optional.of(loc);
        }
        catch (IOException e) {
            AncientWarfareNPC.LOG.error("Error reading image {}", (Object)imageName);
            return Optional.empty();
        }
    }

    @Override
    public Optional<ResourceLocation> getPlayerSkin(String name) {
        SkinManager manager;
        Map map;
        Optional<GameProfile> gp = this.getProfile(name);
        if (gp.isPresent() && (map = (manager = Minecraft.func_71410_x().func_152342_ad()).func_152788_a(gp.get())).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return Optional.of(manager.func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
        }
        return Optional.empty();
    }

    private static final class NpcCategory
    extends DummyConfigElement.DummyCategoryElement {
        private NpcCategory(String arg0) {
            super(arg0, arg0, NpcCategory.getElementList());
        }

        private static List<IConfigElement> getElementList() {
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
            list.add((IConfigElement)new ConfigElement(AWNPCStatics.renderAI));
            list.add((IConfigElement)new ConfigElement(AWNPCStatics.renderFriendlyNames));
            list.add((IConfigElement)new ConfigElement(AWNPCStatics.renderFriendlyHealth));
            list.add((IConfigElement)new ConfigElement(AWNPCStatics.renderHostileNames));
            list.add((IConfigElement)new ConfigElement(AWNPCStatics.renderHostileHealth));
            list.add((IConfigElement)new ConfigElement(AWNPCStatics.renderTeamColors));
            list.add((IConfigElement)new ConfigElement(AWNPCStatics.renderWorkPoints));
            return list;
        }
    }
}

