/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;

@SideOnly(value=Side.CLIENT)
public final class RenderCommandOverlay {
    public static final RenderCommandOverlay INSTANCE = new RenderCommandOverlay();
    private List<Entity> targetEntities = Collections.emptyList();
    private RayTraceResult target;
    private String targetString;

    private RenderCommandOverlay() {
    }

    public RayTraceResult getClientTarget() {
        return this.target;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null || mc.field_71462_r != null) {
            return;
        }
        ItemStack commandBaton = EntityTools.getItemFromEitherHand((EntityPlayer)mc.field_71439_g, ItemCommandBaton.class);
        if (commandBaton.func_190926_b()) {
            return;
        }
        if (evt.phase == TickEvent.Phase.START) {
            this.target = RayTraceUtils.getPlayerTarget((EntityPlayer)mc.field_71439_g, 120.0f, 0.0f);
            if (this.target != null) {
                if (this.target.field_72313_a == RayTraceResult.Type.BLOCK) {
                    this.targetString = this.target.func_178782_a().func_177958_n() + "," + this.target.func_178782_a().func_177956_o() + "," + this.target.func_178782_a().func_177952_p();
                } else if (this.target.field_72313_a == RayTraceResult.Type.ENTITY) {
                    this.targetString = this.target.field_72308_g.func_70005_c_();
                }
            }
            this.targetEntities = ItemCommandBaton.getCommandedEntities((World)mc.field_71441_e, commandBaton);
        } else if (!mc.field_71474_y.field_74330_P) {
            ArrayList<String> entityNames = new ArrayList<String>();
            for (Entity e : this.targetEntities) {
                entityNames.add(e.func_70005_c_());
            }
            ScaledResolution sr = new ScaledResolution(mc);
            int x = sr.func_78326_a() - 10;
            String header = I18n.func_135052_a((String)"guistrings.npc.target", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(header, (float)(x - mc.field_71466_p.func_78256_a(header)), 0.0f, -1);
            if (this.targetString != null) {
                mc.field_71466_p.func_175063_a(this.targetString, (float)(x - mc.field_71466_p.func_78256_a(this.targetString)), 10.0f, -1);
            }
            mc.field_71466_p.func_175063_a(I18n.func_135052_a((String)"guistrings.npc.commanded", (Object[])new Object[0]), 10.0f, 0.0f, -1);
            for (int i = 0; i < entityNames.size(); ++i) {
                mc.field_71466_p.func_175063_a((String)entityNames.get(i), 10.0f, (float)(10 + 10 * i), -1);
            }
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent evt) {
        AxisAlignedBB bb;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71462_r != null || mc.field_71439_g == null) {
            return;
        }
        ItemStack commandBaton = EntityTools.getItemFromEitherHand((EntityPlayer)mc.field_71439_g, ItemCommandBaton.class);
        if (commandBaton.func_190926_b()) {
            return;
        }
        RayTraceResult pos = this.target;
        if (pos != null) {
            bb = null;
            if (pos.field_72313_a == RayTraceResult.Type.BLOCK) {
                bb = new AxisAlignedBB(pos.func_178782_a(), pos.func_178782_a().func_177982_a(1, 1, 1)).func_72314_b(0.1, 0.1, 0.1);
            } else if (pos.field_72313_a == RayTraceResult.Type.ENTITY && pos.field_72308_g.func_174813_aQ() != null && pos.field_72308_g instanceof EntityLivingBase) {
                Entity e = pos.field_72308_g;
                float t = 1.0f - evt.getPartialTicks();
                double dx = e.field_70165_t - e.field_70142_S;
                double dy = e.field_70163_u - e.field_70137_T;
                double dz = e.field_70161_v - e.field_70136_U;
                bb = pos.field_72308_g.func_174813_aQ().func_72317_d((double)t * -dx, (double)t * -dy, (double)t * -dz);
            }
            if (bb != null) {
                bb = RenderTools.adjustBBForPlayerPos(bb, (EntityPlayer)mc.field_71439_g, evt.getPartialTicks());
                RenderTools.drawOutlinedBoundingBox(bb, 1.0f, 1.0f, 1.0f);
            }
        }
        bb = null;
        for (Entity e : this.targetEntities) {
            if (e.func_174813_aQ() == null) continue;
            float t = 1.0f - evt.getPartialTicks();
            double dx = e.field_70165_t - e.field_70142_S;
            double dy = e.field_70163_u - e.field_70137_T;
            double dz = e.field_70161_v - e.field_70136_U;
            bb = e.func_174813_aQ().func_72317_d((double)t * -dx, (double)t * -dy, (double)t * -dz);
            bb = RenderTools.adjustBBForPlayerPos(bb, (EntityPlayer)mc.field_71439_g, evt.getPartialTicks());
            RenderTools.drawOutlinedBoundingBox(bb, 1.0f, 0.0f, 0.0f);
        }
    }
}

