/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.gui.GuiSpawnerAdvanced;
import net.shadowmage.ancientwarfare.structure.gui.GuiSpawnerAdvancedInventory;
import net.shadowmage.ancientwarfare.structure.render.RenderAdvancedSpawner;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;

public class BlockAdvancedSpawner
extends BlockBaseStructure {
    private static final PropertyBool TRANSPARENT = PropertyBool.func_177716_a((String)"transparent");

    public BlockAdvancedSpawner() {
        super(Material.field_151576_e, "advanced_spawner");
        this.func_149711_c(2.0f);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        ItemStack stack = new ItemStack((Block)this);
        SpawnerSettings settings = SpawnerSettings.getDefaultSettings();
        NBTTagCompound defaultTag = new NBTTagCompound();
        settings.writeToNBT(defaultTag);
        stack.func_77983_a("spawnerSettings", (NBTBase)defaultTag);
        items.add((Object)stack);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{TRANSPARENT}).build();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)TRANSPARENT, (Comparable)WorldTools.getTile(world, pos, TileAdvancedSpawner.class).map(s -> s.getSettings().isTransparent()).orElse(false));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        if (world.field_72996_f.contains(entity)) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, p_185477_7_);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAdvancedSpawner();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return WorldTools.getTile((IBlockAccess)world, pos, TileAdvancedSpawner.class).map(TileAdvancedSpawner::getBlockHardness).orElse(Float.valueOf(super.func_176195_g(state, world, pos))).floatValue();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return WorldTools.getTile((IBlockAccess)world, pos, TileAdvancedSpawner.class).map(this::getSpawnerItem).orElse(super.getPickBlock(state, target, world, pos, player));
    }

    private ItemStack getSpawnerItem(TileAdvancedSpawner te) {
        ItemStack item = new ItemStack((Block)this);
        NBTTagCompound settings = new NBTTagCompound();
        te.getSettings().writeToNBT(settings);
        item.func_77983_a("spawnerSettings", (NBTBase)settings);
        return item;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                if (player.func_70093_af()) {
                    NetworkHandler.INSTANCE.openGui(player, 10, pos);
                } else {
                    NetworkHandler.INSTANCE.openGui(player, 8, pos);
                }
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(7, GuiSpawnerAdvanced.class);
        NetworkHandler.registerGui(8, GuiSpawnerAdvanced.class);
        NetworkHandler.registerGui(9, GuiSpawnerAdvancedInventory.class);
        NetworkHandler.registerGui(10, GuiSpawnerAdvancedInventory.class);
        ClientRegistry.bindTileEntitySpecialRenderer(TileAdvancedSpawner.class, (TileEntitySpecialRenderer)new RenderAdvancedSpawner());
    }
}

