/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockSeat;
import net.shadowmage.ancientwarfare.structure.block.WoodVariant;
import net.shadowmage.ancientwarfare.structure.tile.TileChair;
import net.shadowmage.ancientwarfare.structure.util.BlockStateProperties;
import net.shadowmage.ancientwarfare.structure.util.RotationLimit;
import net.shadowmage.ancientwarfare.structure.util.WoodVariantHelper;

public class BlockChair
extends BlockSeat {
    private static final Vec3d SEAT_OFFSET = new Vec3d(0.5, 0.47, 0.5);
    private static final List<AxisAlignedBB> AABBs = ImmutableList.of((Object)new AxisAlignedBB(0.0625, 0.5625, 0.0625, 0.9375, 0.6875, 0.9375), (Object)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.1875, 0.5625, 0.1875), (Object)new AxisAlignedBB(0.8125, 0.0, 0.0625, 0.9375, 0.5625, 0.1875), (Object)new AxisAlignedBB(0.8125, 0.0, 0.8125, 0.9375, 0.5625, 0.9375), (Object)new AxisAlignedBB(0.0625, 0.0, 0.8125, 0.1875, 0.5625, 0.9375));
    private static final Map<EnumFacing, List<AxisAlignedBB>> BOTTOM_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new ImmutableList.Builder().addAll(AABBs).add((Object)new AxisAlignedBB(0.0625, 0.6875, 0.8125, 0.9375, 1.0, 0.9375)).build(), (Object)EnumFacing.SOUTH, (Object)new ImmutableList.Builder().addAll(AABBs).add((Object)new AxisAlignedBB(0.0625, 0.6875, 0.0625, 0.9375, 1.0, 0.1875)).build(), (Object)EnumFacing.EAST, (Object)new ImmutableList.Builder().addAll(AABBs).add((Object)new AxisAlignedBB(0.0625, 0.6875, 0.0625, 0.1875, 1.0, 0.9375)).build(), (Object)EnumFacing.WEST, (Object)new ImmutableList.Builder().addAll(AABBs).add((Object)new AxisAlignedBB(0.8125, 0.6875, 0.0625, 0.9375, 1.0, 0.9375)).build());
    private static final Map<EnumFacing, AxisAlignedBB> TOP_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0625, 0.0, 0.8125, 0.9375, 0.5625, 0.9375), (Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5625, 0.1875), (Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.1875, 0.5625, 0.9375), (Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.8125, 0.0, 0.0625, 0.9375, 0.5625, 0.9375));

    public BlockChair() {
        super(Material.field_151575_d, "chair");
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)WorldTools.getTile(world, pos, TileChair.class).map(TileChair::getPrimaryFacing).orElse(EnumFacing.NORTH));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        WoodVariantHelper.getSubBlocks(this, items);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        world.func_175656_a(pos, state.func_177226_a(BlockStateProperties.VARIANT, (Comparable)((Object)WoodVariantHelper.getVariant(stack))).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(true)));
        WorldTools.getTile((IBlockAccess)world, pos, TileChair.class).ifPresent(te -> te.setPrimaryFacing(placer.func_174811_aO().func_176734_d()));
        world.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(BlockStateProperties.VARIANT, (Comparable)((Object)WoodVariantHelper.getVariant(stack))).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(false)));
        WorldTools.getTile((IBlockAccess)world, pos.func_177984_a(), TileChair.class).ifPresent(te -> {
            te.setPrimaryFacing(placer.func_174811_aO().func_176734_d());
            te.setMainBlockPos(pos);
        });
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return WoodVariantHelper.getPickBlock(this, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateProperties.VARIANT, CoreProperties.FACING, CoreProperties.VISIBLE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BlockStateProperties.VARIANT, (Comparable)((Object)WoodVariant.byMeta(meta & 7))).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf((meta >> 3 & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((WoodVariant)((Object)state.func_177229_b(BlockStateProperties.VARIANT))).getMeta() | ((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? 1 : 0) << 3;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileChair();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? EnumBlockRenderType.MODEL : EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            return super.func_180639_a(world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        return stateDown.func_177230_c().func_180639_a(world, pos.func_177977_b(), stateDown, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        EnumFacing facing = WorldTools.getTile((IBlockAccess)world, pos, TileChair.class).map(TileChair::getPrimaryFacing).orElse(EnumFacing.NORTH);
        return (Boolean)blockState.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? RayTraceUtils.raytraceMultiAABB(BOTTOM_AABBs.get(facing), pos, start, end, (rtr, aabb) -> rtr) : this.func_185503_a(pos, start, end, TOP_AABBs.get(facing));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? AABBs.get(0) : TOP_AABBs.get(WorldTools.getTile(world, pos, TileChair.class).map(TileChair::getPrimaryFacing).orElse(EnumFacing.NORTH));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        EnumFacing facing = WorldTools.getTile((IBlockAccess)world, pos, TileChair.class).map(TileChair::getPrimaryFacing).orElse(EnumFacing.NORTH);
        if (!((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            return TOP_AABBs.get(facing).func_186670_a(pos);
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return RayTraceUtils.getSelectedBoundingBox(BOTTOM_AABBs.get(facing), pos, (EntityPlayer)player);
    }

    @Override
    protected Vec3d getSeatOffset() {
        return SEAT_OFFSET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        WoodVariantHelper.registerClient(this, propString -> "facing=north," + propString + ",visible=true");
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        WoodVariantHelper.getDrops(this, drops, state);
    }

    @Override
    public RotationLimit getRotationLimit(World world, BlockPos seatPos, IBlockState state) {
        return new RotationLimit.FacingThreeQuarters(WorldTools.getTile((IBlockAccess)world, seatPos, TileChair.class).map(TileChair::getPrimaryFacing).orElse(EnumFacing.NORTH));
    }
}

