/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.gui.GuiLootBasket;
import net.shadowmage.ancientwarfare.structure.tile.TileLootBasket;

public class BlockLootBasket
extends BlockBaseStructure {
    private static final AxisAlignedBB SINGLE_SOUTH_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 0.75, 0.9375);
    private static final AxisAlignedBB SINGLE_WEST_EAST = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.75, 1.0);
    private static final AxisAlignedBB DOUBLE_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 0.8125);
    private static final AxisAlignedBB DOUBLE_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.75, 1.0);
    private static final AxisAlignedBB DOUBLE_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.75, 1.0);
    private static final AxisAlignedBB DOUBLE_EAST = new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.75, 1.0);
    private static final PropertyBool DOUBLE = PropertyBool.func_177716_a((String)"double");
    private static final PropertyBool VISIBLE = PropertyBool.func_177716_a((String)"visible");

    public BlockLootBasket() {
        super(Material.field_151577_b, "loot_basket");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return super.getHarvestTool(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING, DOUBLE, VISIBLE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.getDoubleDirection(worldIn, pos).map(facing -> facing == EnumFacing.NORTH || facing == EnumFacing.WEST ? state.func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(false)) : state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)facing.func_176746_e()).func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(true))).orElse(state.func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.func_180495_p(pos.func_177978_c()).func_177230_c() == this) {
            return DOUBLE_NORTH;
        }
        if (source.func_180495_p(pos.func_177968_d()).func_177230_c() == this) {
            return DOUBLE_SOUTH;
        }
        if (source.func_180495_p(pos.func_177976_e()).func_177230_c() == this) {
            return DOUBLE_WEST;
        }
        if (source.func_180495_p(pos.func_177974_f()).func_177230_c() == this) {
            return DOUBLE_EAST;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176740_k() == EnumFacing.Axis.X ? SINGLE_WEST_EAST : SINGLE_SOUTH_NORTH;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileLootBasket();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        int basketsAround = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            if (world.func_180495_p(offsetPos).func_177230_c() != this) continue;
            if (this.isDoubleBasket(world, offsetPos)) {
                return false;
            }
            if (++basketsAround <= 1) continue;
            return false;
        }
        return true;
    }

    private Optional<EnumFacing> getDoubleDirection(IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this) continue;
            return Optional.of(facing);
        }
        return Optional.empty();
    }

    private boolean isDoubleBasket(World world, BlockPos pos) {
        return this.getDoubleDirection((IBlockAccess)world, pos).isPresent();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            WorldTools.getTile((IBlockAccess)world, pos, TileLootBasket.class).ifPresent(te -> te.func_184281_d(player));
            NetworkHandler.INSTANCE.openGui(player, 59, pos);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(59, GuiLootBasket.class);
    }
}

