/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.render.ParticleDummyModel;
import net.shadowmage.ancientwarfare.structure.render.ProtectionFlagRenderer;
import net.shadowmage.ancientwarfare.structure.tile.TileProtectionFlag;

public class BlockProtectionFlag
extends BlockBaseStructure {
    private static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);
    private Set<FlagDefinition> flagDefinitions = new LinkedHashSet<FlagDefinition>();

    public BlockProtectionFlag() {
        super(Material.field_151575_d, "protection_flag");
        this.func_149752_b(6000000.0f);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        float original = super.func_180647_a(state, player, worldIn, pos);
        return WorldTools.getTile((IBlockAccess)worldIn, pos, TileProtectionFlag.class).map(te -> Float.valueOf(te.getPlayerRelativeBlockHardness(player, original))).orElse(Float.valueOf(original)).floatValue();
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_181623_g() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileProtectionFlag();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return WorldTools.getTile((IBlockAccess)world, pos, TileProtectionFlag.class).map(TileProtectionFlag::getItemStack).orElse(new ItemStack((Block)AWStructureBlocks.PROTECTION_FLAG));
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileProtectionFlag) {
            BlockProtectionFlag.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)((TileProtectionFlag)te).getItemStack());
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)WorldTools.getTile(world, pos, TileProtectionFlag.class).map(TileProtectionFlag::getItemStack).orElse(new ItemStack((Block)AWStructureBlocks.PROTECTION_FLAG)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STANDING_AABB;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 16)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(mirrorIn.func_185802_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 16)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ROTATION);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (FlagDefinition flagDefinition : this.flagDefinitions) {
            ItemStack stack = new ItemStack((Block)this);
            stack.func_77982_d(new NBTBuilder().setInteger("topColor", flagDefinition.getTopColor()).setInteger("bottomColor", flagDefinition.getBottomColor()).setString("name", flagDefinition.getName()).build());
            items.add((Object)stack);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int rotation = MathHelper.func_76128_c((double)((double)((placer.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
        return this.func_176223_P().func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(rotation));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        WorldTools.getTile((IBlockAccess)world, pos, TileProtectionFlag.class).ifPresent(te -> te.setFromStack(stack));
    }

    public void addFlagDefinition(FlagDefinition flagDefinition) {
        this.flagDefinitions.add(flagDefinition);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        WorldTools.getTile((IBlockAccess)world, pos, TileProtectionFlag.class).ifPresent(te -> te.onActivatedBy(player));
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ModelResourceLocation modelLocation = new ModelResourceLocation(this.getRegistryName(), "normal");
        ModelRegistryHelper.registerItemRenderer((Item)Item.func_150898_a((Block)this), (IItemRenderer)new ProtectionFlagRenderer());
        ModelRegistryHelper.register((ModelResourceLocation)modelLocation, (IBakedModel)ParticleDummyModel.INSTANCE);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return modelLocation;
            }
        });
        ClientRegistry.bindTileEntitySpecialRenderer(TileProtectionFlag.class, (TileEntitySpecialRenderer)new ProtectionFlagRenderer());
    }

    public static class FlagDefinition {
        private String name;
        private int topColor;
        private int bottomColor;

        public FlagDefinition(String name, int topColor, int bottomColor) {
            this.name = name;
            this.topColor = topColor;
            this.bottomColor = bottomColor;
        }

        public String getName() {
            return this.name;
        }

        private int getTopColor() {
            return this.topColor;
        }

        private int getBottomColor() {
            return this.bottomColor;
        }
    }
}

