/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.structure.block.BlockSeat;
import net.shadowmage.ancientwarfare.structure.util.RotationLimit;

public class BlockScissorSeat
extends BlockSeat {
    private static final Map<EnumFacing, List<AxisAlignedBB>> AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new ImmutableList.Builder().add((Object)new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.5, 0.75)).add((Object)new AxisAlignedBB(0.09375, 0.6875, 0.78125, 0.90625, 0.96875, 0.84375)).add((Object)new AxisAlignedBB(0.125, 0.5, 0.125, 0.1875, 0.6875, 0.8125)).add((Object)new AxisAlignedBB(0.8125, 0.5, 0.125, 0.875, 0.6875, 0.8125)).build(), (Object)EnumFacing.SOUTH, (Object)new ImmutableList.Builder().add((Object)new AxisAlignedBB(0.1875, 0.0, 0.25, 0.8125, 0.5, 0.8125)).add((Object)new AxisAlignedBB(0.09375, 0.6875, 0.15625, 0.90625, 0.96875, 0.21875)).add((Object)new AxisAlignedBB(0.125, 0.5, 0.1875, 0.1875, 0.6875, 0.875)).add((Object)new AxisAlignedBB(0.8125, 0.5, 0.1875, 0.875, 0.6875, 0.875)).build(), (Object)EnumFacing.EAST, (Object)new ImmutableList.Builder().add((Object)new AxisAlignedBB(0.25, 0.0, 0.1875, 0.8125, 0.5, 0.8125)).add((Object)new AxisAlignedBB(0.15625, 0.6875, 0.09375, 0.21875, 0.96875, 0.90625)).add((Object)new AxisAlignedBB(0.1875, 0.5, 0.125, 0.875, 0.6875, 0.1875)).add((Object)new AxisAlignedBB(0.1875, 0.5, 0.8125, 0.875, 0.6875, 0.875)).build(), (Object)EnumFacing.WEST, (Object)new ImmutableList.Builder().add((Object)new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.75, 0.5, 0.8125)).add((Object)new AxisAlignedBB(0.78125, 0.6875, 0.09375, 0.84375, 0.96875, 0.90625)).add((Object)new AxisAlignedBB(0.125, 0.5, 0.125, 0.8125, 0.6875, 0.1875)).add((Object)new AxisAlignedBB(0.125, 0.5, 0.8125, 0.8125, 0.6875, 0.875)).build());

    public BlockScissorSeat() {
        super(Material.field_151575_d, "scissor_seat");
    }

    @Override
    public RotationLimit getRotationLimit(World world, BlockPos seatPos, IBlockState state) {
        return new RotationLimit.FacingQuarter((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING});
    }

    @Override
    protected Vec3d getSeatOffset() {
        return new Vec3d(0.5, 0.27, 0.5);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.field_176754_o[meta & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b();
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)CoreProperties.FACING);
        return RayTraceUtils.raytraceMultiAABB(AABBs.get(facing), pos, start, end, (rtr, aabb) -> rtr);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING)).forEach(aabb -> BlockScissorSeat.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)aabb));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return RayTraceUtils.getSelectedBoundingBox(AABBs.get(facing), pos, (EntityPlayer)player);
    }
}

