/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import codechicken.lib.block.property.unlisted.UnlistedStringProperty;
import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import codechicken.lib.texture.TextureUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.render.BlockStateKeyGenerator;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.gui.GuiSoundBlock;
import net.shadowmage.ancientwarfare.structure.render.SoundBlockRenderer;
import net.shadowmage.ancientwarfare.structure.tile.TileSoundBlock;

public class BlockSoundBlock
extends BlockBaseStructure
implements IBakeryProvider {
    public static final IUnlistedProperty<String> DISGUISE_BLOCK = new UnlistedStringProperty("disguise");

    public BlockSoundBlock() {
        super(Material.field_151576_e, "sound_block");
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{DISGUISE_BLOCK}).build();
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return SoundBlockRenderer.INSTANCE.handleState((IExtendedBlockState)state, world, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSoundBlock();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBlock) {
            WorldTools.getTile((IBlockAccess)world, pos, TileSoundBlock.class).ifPresent(s -> s.setDisguiseState(itemStack));
        }
        if (!world.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 48, pos);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return SoundBlockRenderer.MODEL_LOCATION;
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)SoundBlockRenderer.MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            public TextureAtlasSprite func_177554_e() {
                return TextureUtils.getTexture((String)"minecraft:blocks/jukebox_side");
            }
        });
        ModelLoaderHelper.registerItem(this, SoundBlockRenderer.MODEL_LOCATION);
        ModelBakery.registerBlockKeyGenerator((Block)this, (IBlockStateKeyGenerator)new BlockStateKeyGenerator.Builder().addKeyProperties(DISGUISE_BLOCK).build());
        NetworkHandler.registerGui(48, GuiSoundBlock.class);
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return SoundBlockRenderer.INSTANCE;
    }
}

