/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.gui.GuiStake;
import net.shadowmage.ancientwarfare.structure.render.StakeRenderer;
import net.shadowmage.ancientwarfare.structure.render.property.StructureProperties;
import net.shadowmage.ancientwarfare.structure.render.property.TopBottomPart;
import net.shadowmage.ancientwarfare.structure.tile.TileStake;

public class BlockStake
extends BlockBaseStructure {
    private static final PropertyBool ON_FIRE = PropertyBool.func_177716_a((String)"on_fire");
    private static final AxisAlignedBB POST_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final Map<EnumFacing, AxisAlignedBB> MIDDLE_AABB = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 1.0, 0.6875), (Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.1875, 0.0, 0.3125, 0.8125, 1.0, 1.0), (Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.3125, 0.0, 0.1875, 1.0, 1.0, 0.8125), (Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.0, 0.1875, 0.6875, 1.0, 0.8125));

    public BlockStake() {
        super(Material.field_151575_d, "stake");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING, CoreProperties.VISIBLE, StructureProperties.TOP_BOTTOM_PART, ON_FIRE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a(StructureProperties.TOP_BOTTOM_PART, (Comparable)((Object)TopBottomPart.byMeta(meta >> 2 & 1))).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf((meta >> 3 & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b() | ((TopBottomPart)((Object)state.func_177229_b(StructureProperties.TOP_BOTTOM_PART))).getMeta() << 2 | ((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? 1 : 0) << 3;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(StructureProperties.TOP_BOTTOM_PART) == TopBottomPart.BOTTOM) {
            return state.func_177226_a((IProperty)ON_FIRE, (Comparable)WorldTools.getTile(world, pos, TileStake.class).map(TileStake::burns).orElse(false));
        }
        return state.func_177226_a((IProperty)ON_FIRE, (Comparable)Boolean.valueOf(false));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TopBottomPart part = (TopBottomPart)((Object)state.func_177229_b(StructureProperties.TOP_BOTTOM_PART));
        BlockPos tePos = pos;
        if (!((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            tePos = pos.func_177979_c(2);
        } else if (part == TopBottomPart.TOP) {
            tePos = pos.func_177977_b();
        }
        return WorldTools.getTile(world, tePos, TileStake.class).map(te -> part == TopBottomPart.BOTTOM && te.burns() || te.isEntityOnFire()).orElse(false) != false ? 15 : 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? super.func_149645_b(state) : EnumBlockRenderType.INVISIBLE;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b(StructureProperties.TOP_BOTTOM_PART) != TopBottomPart.BOTTOM) {
            return false;
        }
        if (!world.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 60, pos);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos.func_177981_b(2), state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(StructureProperties.TOP_BOTTOM_PART, (Comparable)((Object)TopBottomPart.TOP)).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(StructureProperties.TOP_BOTTOM_PART, (Comparable)((Object)TopBottomPart.TOP)).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos, state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(StructureProperties.TOP_BOTTOM_PART, (Comparable)((Object)TopBottomPart.BOTTOM)).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(true)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TopBottomPart part = (TopBottomPart)((Object)state.func_177229_b(StructureProperties.TOP_BOTTOM_PART));
        if (part == TopBottomPart.BOTTOM) {
            return super.func_185496_a(state, source, pos);
        }
        return (Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? MIDDLE_AABB.get(state.func_177229_b((IProperty)CoreProperties.FACING)) : POST_AABB;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(StructureProperties.TOP_BOTTOM_PART) != TopBottomPart.BOTTOM) {
            IBlockState currentState = state;
            BlockPos currentPos = pos;
            for (int i = 1; i < 3 && currentState.func_177229_b(StructureProperties.TOP_BOTTOM_PART) != TopBottomPart.BOTTOM; ++i) {
                currentPos = pos.func_177979_c(i);
                currentState = world.func_180495_p(currentPos);
                if (currentState.func_177230_c() == this) continue;
                return;
            }
            if (currentState.func_177229_b(StructureProperties.TOP_BOTTOM_PART) == TopBottomPart.BOTTOM) {
                currentState.func_177230_c().func_180663_b(world, currentPos, currentState);
                return;
            }
        }
        world.func_175698_g(pos.func_177981_b(2));
        world.func_175698_g(pos.func_177984_a());
        world.func_175698_g(pos);
        super.func_180663_b(world, pos, state);
        world.func_175664_x(pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(StructureProperties.TOP_BOTTOM_PART) == TopBottomPart.BOTTOM;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileStake();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ResourceLocation assetLocation = new ResourceLocation("ancientwarfare", "structure/" + this.getRegistryName().func_110623_a());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(assetLocation, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        ModelLoaderHelper.registerItem(this, "structure", "inventory");
        ClientRegistry.bindTileEntitySpecialRenderer(TileStake.class, (TileEntitySpecialRenderer)new StakeRenderer());
        NetworkHandler.registerGui(60, GuiStake.class);
    }
}

