/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.structure.block.BlockSeat;
import net.shadowmage.ancientwarfare.structure.util.RotationLimit;

public class BlockTribalChair
extends BlockSeat {
    private static final Map<EnumFacing, List<AxisAlignedBB>> BOTTOM_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new ImmutableList.Builder().add((Object)new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 0.5625, 0.9375)).add((Object)new AxisAlignedBB(0.0, 0.5625, 0.8125, 1.0, 1.0, 0.9375)).add((Object)new AxisAlignedBB(0.0, 0.5625, 0.0625, 0.125, 0.875, 0.8125)).add((Object)new AxisAlignedBB(0.875, 0.5625, 0.0625, 1.0, 0.875, 0.8125)).build(), (Object)EnumFacing.SOUTH, (Object)new ImmutableList.Builder().add((Object)new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 0.5625, 0.9375)).add((Object)new AxisAlignedBB(0.0, 0.5625, 0.0625, 1.0, 1.0, 0.1875)).add((Object)new AxisAlignedBB(0.0, 0.5625, 0.1875, 0.125, 0.875, 0.9375)).add((Object)new AxisAlignedBB(0.875, 0.5625, 0.1875, 1.0, 0.875, 0.9375)).build(), (Object)EnumFacing.EAST, (Object)new ImmutableList.Builder().add((Object)new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.5625, 1.0)).add((Object)new AxisAlignedBB(0.0625, 0.5625, 0.0, 0.1875, 1.0, 1.0)).add((Object)new AxisAlignedBB(0.1875, 0.5625, 0.0, 0.9375, 0.875, 0.125)).add((Object)new AxisAlignedBB(0.1875, 0.5625, 0.875, 0.9375, 0.875, 1.0)).build(), (Object)EnumFacing.WEST, (Object)new ImmutableList.Builder().add((Object)new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.5625, 1.0)).add((Object)new AxisAlignedBB(0.8125, 0.5625, 0.0, 0.9375, 1.0, 1.0)).add((Object)new AxisAlignedBB(0.0625, 0.5625, 0.0, 0.8125, 0.875, 0.125)).add((Object)new AxisAlignedBB(0.0625, 0.5625, 0.875, 0.8125, 0.875, 1.0)).build());
    private static final Map<EnumFacing, AxisAlignedBB> TOP_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 0.5625, 0.9375), (Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 0.5625, 0.1875), (Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.0625, 0.0, 0.0, 0.1875, 0.5625, 1.0), (Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.8125, 0.0, 0.0, 0.9375, 0.5625, 1.0));

    public BlockTribalChair() {
        super(Material.field_151575_d, "tribal_chair");
    }

    @Override
    public RotationLimit getRotationLimit(World world, BlockPos seatPos, IBlockState state) {
        return new RotationLimit.FacingQuarter((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockPos otherPos;
        BlockPos blockPos = otherPos = (Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? pos.func_177984_a() : pos.func_177977_b();
        if (world.func_180495_p(otherPos).func_177230_c() == this) {
            world.func_175698_g(otherPos);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING, CoreProperties.VISIBLE});
    }

    @Override
    protected Vec3d getSeatOffset() {
        return new Vec3d(0.5, 0.35, 0.5);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.field_176754_o[meta & 3]).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf((meta >> 2 & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? 1 : 0) << 2;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? EnumBlockRenderType.MODEL : EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            return super.func_180639_a(world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        return stateDown.func_177230_c().func_180639_a(world, pos.func_177977_b(), stateDown, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)CoreProperties.FACING);
        return (Boolean)blockState.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? RayTraceUtils.raytraceMultiAABB(BOTTOM_AABBs.get(facing), pos, start, end, (rtr, aabb) -> rtr) : this.func_185503_a(pos, start, end, TOP_AABBs.get(facing));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            BOTTOM_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING)).forEach(aabb -> BlockTribalChair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)aabb));
        } else {
            BlockTribalChair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TOP_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING);
        if (!((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            return TOP_AABBs.get(facing).func_186670_a(pos);
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return RayTraceUtils.getSelectedBoundingBox(BOTTOM_AABBs.get(facing), pos, (EntityPlayer)player);
    }
}

