/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.item.ItemLootChestPlacer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;

public class ContainerLootChestPlacer
extends ContainerBase {
    private static final String BLOCK_STACK_TAG = "blockStack";
    private final ItemStack placer;

    public ContainerLootChestPlacer(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.placer = EntityTools.getItemFromEitherHand(player, ItemLootChestPlacer.class);
    }

    public List<String> getLootTableNames() {
        return LootTableList.func_186374_a().stream().map(ResourceLocation::toString).filter(rl -> !AWStructureStatics.lootTableExclusions.contains(rl)).collect(Collectors.toList());
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(BLOCK_STACK_TAG)) {
            this.setBlockStack(new ItemStack(tag.func_74775_l(BLOCK_STACK_TAG)));
            return;
        }
        this.setLootSettings(LootSettings.deserializeNBT(tag));
    }

    public void setLootSettings(LootSettings lootSettings) {
        if (this.player.field_70170_p.field_72995_K) {
            this.sendDataToServer(lootSettings.serializeNBT());
        }
        ItemLootChestPlacer.setLootSettings(this.placer, lootSettings);
    }

    public Optional<LootSettings> getLootSettings() {
        return ItemLootChestPlacer.getLootSettings(this.placer);
    }

    public ItemStack getBlockStack() {
        return ItemLootChestPlacer.getBlockStack(this.placer);
    }

    public void setBlockStack(ItemStack blockStack) {
        if (this.player.field_70170_p.field_72995_K) {
            this.sendDataToServer(new NBTBuilder().setTag(BLOCK_STACK_TAG, blockStack.func_77955_b(new NBTTagCompound())).build());
        }
        ItemLootChestPlacer.setBlockStack(this.placer, blockStack);
    }
}

