/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.init.AWStructureItems;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureScanner;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.tile.TileStructureScanner;

public class ContainerStructureScanner
extends ContainerBase {
    private static final String INCLUDE_TAG = "include";
    private static final String VALIDATOR_TAG = "validator";
    private static final String BOUNDS_ACTIVE_TAG = "boundsActive";
    private ItemStack scanner;
    private final EnumHand hand;
    private final TileStructureScanner scannerTile;

    public Optional<TileStructureScanner> getScannerTile() {
        return Optional.ofNullable(this.scannerTile);
    }

    public ContainerStructureScanner(final EntityPlayer player, int x, int y, int z) {
        super(player);
        if (y > 0) {
            this.scannerTile = WorldTools.getTile((IBlockAccess)player.field_70170_p, new BlockPos(x, y, z), TileStructureScanner.class).orElse(null);
            this.scanner = this.scannerTile.getScannerInventory().getStackInSlot(0).func_77946_l();
            SlotItemHandler slot = new SlotItemHandler((IItemHandler)this.scannerTile.getScannerInventory(), 0, 8, 8){

                public void func_75218_e() {
                    super.func_75218_e();
                    Optional<TileStructureScanner> te = ContainerStructureScanner.this.getScannerTile();
                    ContainerStructureScanner.this.scanner = te.map(tileStructureScanner -> tileStructureScanner.getScannerInventory().getStackInSlot(0)).orElse(ItemStack.field_190927_a);
                    if (player.field_70170_p.field_72995_K) {
                        ContainerStructureScanner.this.field_75149_d.forEach(l -> l.func_71111_a((Container)ContainerStructureScanner.this, 0, ContainerStructureScanner.this.scanner));
                    }
                }
            };
            this.func_75146_a((Slot)slot);
            this.addPlayerSlots();
            this.hand = null;
        } else {
            this.scannerTile = null;
            this.scanner = EntityTools.getItemFromEitherHand(player, ItemStructureScanner.class);
            this.hand = EntityTools.getHandHoldingItem((EntityLivingBase)player, AWStructureItems.STRUCTURE_SCANNER);
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (!tag.func_74764_b("mode")) {
            return;
        }
        String mode = tag.func_74779_i("mode");
        if (mode.equals("export") && ItemStructureScanner.scanStructure(this.player.field_70170_p, this.scanner) && !this.getScannerTile().isPresent()) {
            ItemStructureScanner.clearSettings(this.scanner);
            this.saveScannerData(this.player);
        } else if (mode.equals("restore")) {
            this.getScannerTile().ifPresent(t -> t.restoreTemplate(tag.func_74779_i("templateName")));
        } else if (mode.equals("update")) {
            if (tag.func_74764_b("name")) {
                this.updateName(tag.func_74779_i("name"));
            } else if (tag.func_74764_b(INCLUDE_TAG)) {
                this.setIncludeImmediately(tag.func_74767_n(INCLUDE_TAG));
            } else if (tag.func_74764_b(VALIDATOR_TAG)) {
                NBTTagCompound validatorNBT = tag.func_74775_l(VALIDATOR_TAG);
                StructureValidationType.getTypeFromName(validatorNBT.func_74779_i("validationType")).ifPresent(type -> {
                    StructureValidator validator = type.getValidator();
                    validator.readFromNBT(validatorNBT);
                    this.setValidator(validator);
                });
            } else if (tag.func_74764_b(BOUNDS_ACTIVE_TAG)) {
                this.setBoundsActive(tag.func_74767_n(BOUNDS_ACTIVE_TAG));
            } else if (tag.func_74764_b("mods")) {
                this.updateModDependencies(NBTHelper.getStringSet(tag.func_150295_c("mods", 8)));
            }
        }
    }

    public boolean hasScanner() {
        return !this.scanner.func_190926_b();
    }

    private void sendUpdateData(String name, NBTBase data) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("mode", "update");
        tag.func_74782_a(name, data);
        this.sendDataToServer(tag);
    }

    private void saveScannerData(EntityPlayer player) {
        if (!this.getScannerTile().isPresent()) {
            player.func_184611_a(this.hand, this.scanner);
            return;
        }
        this.getScannerTile().ifPresent(tile -> {
            tile.getScannerInventory().setStackInSlot(0, this.scanner);
            tile.func_70296_d();
        });
    }

    public void export() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("mode", "export");
        this.sendDataToServer(tag);
    }

    public void updateName(String name) {
        ItemStructureScanner.setStructureName(this.scanner, name);
        if (this.player.field_70170_p.field_72995_K) {
            this.sendUpdateData("name", (NBTBase)new NBTTagString(name));
            return;
        }
        this.saveScannerData(this.player);
    }

    public Set<String> getModDependencies() {
        return ItemStructureScanner.getModDependencies(this.scanner);
    }

    public String getName() {
        return ItemStructureScanner.getStructureName(this.scanner);
    }

    public String getValidationTypeName() {
        return ItemStructureScanner.getValidator((ItemStack)this.scanner).validationType.getName();
    }

    public void setIncludeImmediately(boolean checked) {
        ItemStructureScanner.setIncludeImmediately(this.scanner, checked);
        if (this.player.field_70170_p.field_72995_K) {
            this.sendUpdateData(INCLUDE_TAG, (NBTBase)new NBTTagByte((byte)(checked ? 1 : 0)));
            return;
        }
        this.saveScannerData(this.player);
    }

    public boolean getIncludeImmediately() {
        return ItemStructureScanner.getIncludeImmediately(this.scanner);
    }

    public StructureValidator getValidator() {
        return ItemStructureScanner.getValidator(this.scanner);
    }

    public void setValidator(StructureValidator validator) {
        ItemStructureScanner.setValidator(this.scanner, validator);
        if (this.player.field_70170_p.field_72995_K) {
            this.sendUpdateData(VALIDATOR_TAG, (NBTBase)validator.serializeToNBT());
            return;
        }
        this.saveScannerData(this.player);
    }

    public void updateValidator(Consumer<StructureValidator> doUpdate) {
        StructureValidator validator = this.getValidator();
        doUpdate.accept(validator);
        this.setValidator(validator);
    }

    public void toggleBounds() {
        this.setBoundsActive(!this.getBoundsActive());
    }

    private void setBoundsActive(boolean boundsActive) {
        if (this.player.field_70170_p.field_72995_K) {
            this.sendUpdateData(BOUNDS_ACTIVE_TAG, (NBTBase)new NBTTagByte((byte)(boundsActive ? 1 : 0)));
        }
        this.getScannerTile().ifPresent(t -> t.setBoundsActive(boundsActive));
    }

    public boolean getBoundsActive() {
        return this.getScannerTile().map(TileStructureScanner::getBoundsActive).orElse(false);
    }

    public boolean getReadyToExport() {
        return ItemStructureScanner.readyToExport(this.scanner);
    }

    public void restoreTemplate(String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("mode", "restore");
        tag.func_74778_a("templateName", name);
        this.sendDataToServer(tag);
    }

    public void updateModDependencies(Set<String> mods) {
        ItemStructureScanner.setModDependencies(this.scanner, mods);
        if (this.player.field_70170_p.field_72995_K) {
            this.sendUpdateData("mods", (NBTBase)NBTHelper.getNBTStringList(mods));
            return;
        }
        this.saveScannerData(this.player);
    }
}

