/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvancedBase;
import net.shadowmage.ancientwarfare.structure.gui.GuiSpawnerAdvancedAddEntity;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;

public class GuiSpawnerAdvanced
extends GuiContainerBase<ContainerSpawnerAdvancedBase> {
    private CompositeScrolled area;
    private HashMap<NumberInput, SpawnerSettings.EntitySpawnGroup> groupMapByInput = new HashMap();
    private HashMap<Button, SpawnerSettings.EntitySpawnGroup> groupMapByButton = new HashMap();
    private HashMap<NumberInput, SpawnerSettings.EntitySpawnSettings> settingsMapByInput = new HashMap();
    private HashMap<Button, SpawnerSettings.EntitySpawnSettings> settingsMapByButton = new HashMap();

    public GuiSpawnerAdvanced(ContainerBase par1Container) {
        super(par1Container);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).sendSettingsToServer();
        return true;
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 40, 256, 200);
        this.addGuiElement(this.area);
        Button done = new Button(193, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                GuiSpawnerAdvanced.this.closeGui();
            }
        };
        this.addGuiElement(done);
        Label label = new Label(8, 8, "guistrings.spawner.set_spawn_settings");
        this.addGuiElement(label);
    }

    @Override
    public void setupElements() {
        Button button;
        this.area.clearElements();
        this.groupMapByButton.clear();
        this.groupMapByInput.clear();
        this.settingsMapByButton.clear();
        this.settingsMapByInput.clear();
        int totalHeight = 3;
        Checkbox box = new Checkbox(8, totalHeight, 16, 16, "guistrings.spawner.light_sensitive"){

            @Override
            public void onToggled() {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.toggleLightSensitive();
            }
        };
        box.setChecked(((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.isLightSensitive());
        this.area.addGuiElement(box);
        box = new Checkbox(8, totalHeight += 16, 16, 16, "guistrings.spawner.redstone_sensitive"){

            @Override
            public void onToggled() {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.toggleRespondToRedstone();
            }
        };
        box.setChecked(((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.isRespondToRedstone());
        this.area.addGuiElement(box);
        box = new Checkbox(8, totalHeight += 16, 16, 16, "guistrings.spawner.redstone_mode"){

            @Override
            public void onToggled() {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.toggleRedstoneMode();
            }
        };
        box.setChecked(((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getRedstoneMode());
        this.area.addGuiElement(box);
        box = new Checkbox(8, totalHeight += 16, 16, 16, "guistrings.spawner.transparent"){

            @Override
            public void onToggled() {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.toggleTransparent();
            }
        };
        box.setChecked(((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.isTransparent());
        this.area.addGuiElement(box);
        box = new Checkbox(8, totalHeight += 16, 16, 16, "guistrings.spawner.debug_mode"){

            @Override
            public void onToggled() {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.toggleDebugMode();
            }
        };
        box.setChecked(((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.isDebugMode());
        this.area.addGuiElement(box);
        Label label = new Label(8, totalHeight += 20, "guistrings.required_player_range");
        this.area.addGuiElement(label);
        NumberInput input = new NumberInput(180, totalHeight, 50, ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getPlayerRange(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.setPlayerRange((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.max_nearby_entities");
        this.area.addGuiElement(label);
        input = new NumberInput(180, totalHeight, 50, ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getMaxNearbyMonsters(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.setMaxNearbyMonsters((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.mob_range");
        this.area.addGuiElement(label);
        input = new NumberInput(180, totalHeight, 50, ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getMobRange(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.setMobRange((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.spawn_range");
        this.area.addGuiElement(label);
        input = new NumberInput(180, totalHeight, 50, ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getSpawnRange(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.setSpawnRange((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.delay");
        this.area.addGuiElement(label);
        input = new NumberInput(180, totalHeight, 50, ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getSpawnDelay(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.setSpawnDelay((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.min_spawn_delay");
        this.area.addGuiElement(label);
        input = new NumberInput(180, totalHeight, 50, ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getMinDelay(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.setMinDelay((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.max_spawn_delay");
        this.area.addGuiElement(label);
        input = new NumberInput(180, totalHeight, 50, ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getMaxDelay(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.setMaxDelay((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.xp_to_drop");
        this.area.addGuiElement(label);
        input = new NumberInput(180, totalHeight, 50, ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getXpToDrop(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.setXpToDrop((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.block_hardness");
        this.area.addGuiElement(label);
        input = new NumberInput(180, totalHeight, 50, ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getBlockHardness(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.setBlockHardness(value);
            }
        };
        input.setAllowNegative();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 16, "guistrings.spawner.spawn_groups");
        this.area.addGuiElement(label);
        totalHeight += 12;
        List<SpawnerSettings.EntitySpawnGroup> spawnGroups = ((ContainerSpawnerAdvancedBase)((Object)this.getContainer())).settings.getSpawnGroups();
        for (SpawnerSettings.EntitySpawnGroup group : spawnGroups) {
            button = new Button(145, totalHeight, 95, 12, "guistrings.spawner.remove_group"){

                @Override
                protected void onPressed() {
                    SpawnerSettings.EntitySpawnGroup g = (SpawnerSettings.EntitySpawnGroup)GuiSpawnerAdvanced.this.groupMapByButton.get(this);
                    ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.getSpawnGroups().remove(g);
                    GuiSpawnerAdvanced.this.groupMapByButton.remove(this);
                    GuiSpawnerAdvanced.this.refreshGui();
                }
            };
            this.groupMapByButton.put(button, group);
            this.area.addGuiElement(button);
            label = new Label(8, totalHeight, "guistrings.spawner.group_weight");
            this.area.addGuiElement(label);
            input = new NumberInput(100, totalHeight, 30, group.getWeight(), this){

                @Override
                public void onValueUpdated(float value) {
                    SpawnerSettings.EntitySpawnGroup g = (SpawnerSettings.EntitySpawnGroup)GuiSpawnerAdvanced.this.groupMapByInput.get(this);
                    if (g != null) {
                        g.setWeight((int)value);
                    }
                }
            };
            input.setIntegerValue();
            this.groupMapByInput.put(input, group);
            this.area.addGuiElement(input);
            label = new Label(8, totalHeight += 14, "guistrings.spawner.entity_list");
            this.area.addGuiElement(label);
            label = new Label(130, totalHeight, "guistrings.spawner.min");
            this.area.addGuiElement(label);
            label = new Label(160, totalHeight, "guistrings.spawner.max");
            this.area.addGuiElement(label);
            label = new Label(190, totalHeight, "guistrings.spawner.total");
            this.area.addGuiElement(label);
            totalHeight += 12;
            List<SpawnerSettings.EntitySpawnSettings> entitySettings = group.getEntitiesToSpawn();
            for (SpawnerSettings.EntitySpawnSettings settings : entitySettings) {
                if (settings == null) continue;
                button = new Button(30, totalHeight, 100, 12, settings.getEntityName()){

                    @Override
                    protected void onPressed() {
                        SpawnerSettings.EntitySpawnSettings set = (SpawnerSettings.EntitySpawnSettings)GuiSpawnerAdvanced.this.settingsMapByButton.get(this);
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSpawnerAdvancedAddEntity(GuiSpawnerAdvanced.this, (SpawnerSettings.EntitySpawnGroup)GuiSpawnerAdvanced.this.groupMapByButton.get(this), set));
                    }
                };
                this.groupMapByButton.put(button, group);
                this.settingsMapByButton.put(button, settings);
                this.area.addGuiElement(button);
                input = new NumberInput(130, totalHeight, 30, settings.getSpawnMin(), this){

                    @Override
                    public void onValueUpdated(float value) {
                        ((SpawnerSettings.EntitySpawnSettings)GuiSpawnerAdvanced.this.settingsMapByInput.get(this)).setSpawnCountMin((int)value);
                    }
                };
                this.settingsMapByInput.put(input, settings);
                this.area.addGuiElement(input);
                input.setIntegerValue();
                input = new NumberInput(160, totalHeight, 30, settings.getSpawnMax(), this){

                    @Override
                    public void onValueUpdated(float value) {
                        ((SpawnerSettings.EntitySpawnSettings)GuiSpawnerAdvanced.this.settingsMapByInput.get(this)).setSpawnCountMax((int)value);
                    }
                };
                this.settingsMapByInput.put(input, settings);
                this.area.addGuiElement(input);
                input.setIntegerValue();
                input = new NumberInput(190, totalHeight, 30, settings.getSpawnTotal(), this){

                    @Override
                    public void onValueUpdated(float value) {
                        ((SpawnerSettings.EntitySpawnSettings)GuiSpawnerAdvanced.this.settingsMapByInput.get(this)).setSpawnLimitTotal((int)value);
                    }
                };
                this.settingsMapByInput.put(input, settings);
                this.area.addGuiElement(input);
                input.setIntegerValue();
                input.setAllowNegative();
                button = new Button(220, totalHeight, 12, 12, "guistrings.spawner.remove"){

                    @Override
                    protected void onPressed() {
                        SpawnerSettings.EntitySpawnSettings set = (SpawnerSettings.EntitySpawnSettings)GuiSpawnerAdvanced.this.settingsMapByButton.get(this);
                        SpawnerSettings.EntitySpawnGroup g = (SpawnerSettings.EntitySpawnGroup)GuiSpawnerAdvanced.this.groupMapByButton.get(this);
                        g.getEntitiesToSpawn().remove(set);
                        GuiSpawnerAdvanced.this.refreshGui();
                    }
                };
                this.settingsMapByButton.put(button, settings);
                this.groupMapByButton.put(button, group);
                this.area.addGuiElement(button);
                totalHeight += 12;
            }
            button = new Button(30, totalHeight, 120, 12, "guistrings.spawner.add_entity"){

                @Override
                protected void onPressed() {
                    SpawnerSettings.EntitySpawnGroup g = (SpawnerSettings.EntitySpawnGroup)GuiSpawnerAdvanced.this.groupMapByButton.get(this);
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSpawnerAdvancedAddEntity(GuiSpawnerAdvanced.this, g, null));
                }
            };
            this.area.addGuiElement(button);
            this.groupMapByButton.put(button, group);
            totalHeight += 14;
        }
        button = new Button(8, totalHeight += 8, 120, 12, "guistrings.spawner.add_group"){

            @Override
            protected void onPressed() {
                ((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings.addSpawnGroup(new SpawnerSettings.EntitySpawnGroup(((ContainerSpawnerAdvancedBase)((Object)GuiSpawnerAdvanced.this.getContainer())).settings));
                GuiSpawnerAdvanced.this.refreshGui();
            }
        };
        this.area.addGuiElement(button);
        this.area.setAreaSize(totalHeight += 12);
    }
}

