/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.gui.elements.Tooltip;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;

public class GuiSpawnerAdvancedEntitySelection
extends GuiContainerBase {
    private final GuiContainerBase parent;
    private final SpawnerSettings.EntitySpawnSettings settings;
    private CompositeScrolled area;
    private Label selectionLabel;
    private Text search;

    public GuiSpawnerAdvancedEntitySelection(GuiContainerBase parent, SpawnerSettings.EntitySpawnSettings settings) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
        this.settings = settings;
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 42, 256, 200);
        this.addGuiElement(this.area);
        Label label = new Label(8, 6, "guistrings.spawner.select_entity");
        this.addGuiElement(label);
        Button button = new Button(this.field_146999_f - 8 - 55, 6, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSpawnerAdvancedEntitySelection.this.parent);
            }
        };
        this.addGuiElement(button);
        this.selectionLabel = new Label(8, 18, this.settings.getEntityName());
        this.addGuiElement(this.selectionLabel);
        this.search = new Text(8, 30, 240, "", this){

            @Override
            protected void handleKeyInput(int keyCode, char ch) {
                String old = this.getText();
                super.handleKeyInput(keyCode, ch);
                String text = this.getText();
                if (!text.equals(old)) {
                    GuiSpawnerAdvancedEntitySelection.this.refreshGui();
                }
            }
        };
        this.addGuiElement(this.search);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        List entities = ForgeRegistries.ENTITIES.getKeys().stream().filter(rl -> {
            if (rl == null || AWStructureStatics.excludedSpawnerEntities.contains(rl.toString())) {
                return false;
            }
            return this.search.getText().isEmpty() || rl.toString().contains(this.search.getText().toLowerCase());
        }).sorted(Comparator.comparing(registryName -> I18n.func_135052_a((String)EntityTools.getUnlocName(registryName), (Object[])new Object[0]))).collect(Collectors.toList());
        int totalHeight = 8;
        for (final ResourceLocation registryName2 : entities) {
            Button button = new Button(8, totalHeight, 232, 12, I18n.func_135052_a((String)EntityTools.getUnlocName(registryName2), (Object[])new Object[0])){

                @Override
                protected void onPressed() {
                    GuiSpawnerAdvancedEntitySelection.this.settings.setEntityToSpawn(registryName2);
                    GuiSpawnerAdvancedEntitySelection.this.selectionLabel.setText(GuiSpawnerAdvancedEntitySelection.this.settings.getEntityName());
                    GuiSpawnerAdvancedEntitySelection.this.refreshGui();
                }
            };
            Tooltip tip = new Tooltip(50, 10);
            tip.addTooltipElement(new Label(0, 0, registryName2.toString()));
            button.setTooltip(tip);
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }
}

