/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiSelectFromList;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.container.ContainerStake;

public class GuiStake
extends GuiContainerBase<ContainerStake> {
    private static final int SUBCONTROLS_INDENT = 24;
    private Checkbox showEntity;
    private Checkbox entityOnFire;

    public GuiStake(ContainerBase container) {
        super(container, 200, 200);
    }

    @Override
    public void initElements() {
    }

    @Override
    public void setupElements() {
        this.clearElements();
        int totalHeight = 8;
        this.showEntity = new Checkbox(8, totalHeight, 16, 16, "guistrings.stake.show_entity"){

            @Override
            public void onToggled() {
                if (this.checked()) {
                    ((ContainerStake)((Object)GuiStake.this.getContainer())).getStake().setEntityName(new ResourceLocation("zombie"));
                } else {
                    ((ContainerStake)((Object)GuiStake.this.getContainer())).getStake().resetEntityName();
                }
                GuiStake.this.refreshGui();
            }
        };
        this.addGuiElement(this.showEntity);
        this.showEntity.setChecked(((ContainerStake)((Object)this.getContainer())).getStake().getRenderEntity().isPresent());
        totalHeight += 18;
        if (this.showEntity.checked()) {
            totalHeight = this.addEntityControls(totalHeight);
        }
        Checkbox burns = new Checkbox(8, totalHeight + 4, 16, 16, "guistrings.stake.burns"){

            @Override
            public void onToggled() {
                ((ContainerStake)((Object)GuiStake.this.getContainer())).getStake().setBurns(this.checked());
                super.onToggled();
            }
        };
        burns.setChecked(((ContainerStake)((Object)this.getContainer())).getStake().burns());
        this.addGuiElement(burns);
    }

    private int addEntityControls(int totalHeight) {
        this.addGuiElement(new Button(24, totalHeight, 160, 12, ((ContainerStake)((Object)this.getContainer())).getStake().getEntityName().toString()){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a(new GuiSelectFromList<ResourceLocation>(GuiStake.this, ((ContainerStake)((Object)GuiStake.this.getContainer())).getStake().getEntityName(), ResourceLocation::toString, this::getEntityNames, s -> {
                    this.setText(s.toString());
                    ((ContainerStake)((Object)((Object)GuiStake.this.getContainer()))).getStake().setEntityName((ResourceLocation)s);
                }));
                GuiStake.this.refreshGui();
            }

            private List<ResourceLocation> getEntityNames() {
                return ForgeRegistries.ENTITIES.getKeys().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
            }
        });
        this.entityOnFire = new Checkbox(24, totalHeight += 16, 16, 16, "guistrings.stake.entity_on_fire"){

            @Override
            public void onToggled() {
                ((ContainerStake)((Object)GuiStake.this.getContainer())).getStake().setEntityOnFire(this.checked());
                super.onToggled();
            }
        };
        this.entityOnFire.setChecked(((ContainerStake)((Object)this.getContainer())).getStake().isEntityOnFire());
        this.addGuiElement(this.entityOnFire);
        return totalHeight + 16;
    }

    @Override
    protected boolean onGuiCloseRequested() {
        ((ContainerStake)((Object)this.getContainer())).updateServer();
        BlockTools.notifyBlockUpdate(((ContainerStake)((Object)this.getContainer())).getStake());
        ((ContainerStake)((Object)this.getContainer())).getStake().func_145831_w().func_175664_x(((ContainerStake)((Object)this.getContainer())).getStake().func_174877_v());
        return true;
    }
}

