/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FloodFillPathfinder {
    private int maxDist = 40;
    World world;
    private BlockPos startingPos;
    Block block;
    private IBlockState targetState;
    boolean searchUpwards;
    boolean searchDownwards;
    ArrayList<BlockPos> openList = new ArrayList();
    Set<BlockPos> closedList = new HashSet<BlockPos>();
    Set<BlockPos> neighborCache = new HashSet<BlockPos>();
    Set<BlockPos> returnSet = new HashSet<BlockPos>();

    public FloodFillPathfinder(World world, BlockPos startingPos, Block block, IBlockState targetState, boolean up, boolean down) {
        this.world = world;
        this.startingPos = startingPos;
        this.block = block;
        this.targetState = targetState;
        this.searchUpwards = up;
        this.searchDownwards = down;
    }

    public Set<BlockPos> doFloodFill() {
        this.openList.add(this.startingPos);
        while (!this.openList.isEmpty()) {
            BlockPos pos = this.openList.remove(0);
            this.returnSet.add(pos);
            this.addNeighbors(pos);
            for (BlockPos p1 : this.neighborCache) {
                if (this.returnSet.contains(p1) || this.closedList.contains(p1) || this.openList.contains(p1) || !this.isValidPosition(p1)) continue;
                this.openList.add(p1);
            }
            this.neighborCache.clear();
        }
        return this.returnSet;
    }

    private boolean isValidPosition(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        return this.isWithinDist(pos) && state.func_177230_c() == this.block && state.equals(this.targetState);
    }

    private boolean isWithinDist(BlockPos pos) {
        return pos.func_177958_n() >= this.startingPos.func_177958_n() - this.maxDist && pos.func_177958_n() <= this.startingPos.func_177958_n() + this.maxDist && pos.func_177956_o() >= this.startingPos.func_177956_o() - this.maxDist && pos.func_177956_o() <= this.startingPos.func_177956_o() + this.maxDist && pos.func_177952_p() >= this.startingPos.func_177952_p() - this.maxDist && pos.func_177952_p() <= this.startingPos.func_177952_p() + this.maxDist;
    }

    private void addNeighbors(BlockPos pos) {
        this.neighborCache.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()));
        this.neighborCache.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()));
        this.neighborCache.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1));
        this.neighborCache.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1));
        if (this.searchUpwards) {
            this.neighborCache.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o() + 1, pos.func_177952_p()));
            this.neighborCache.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p()));
            this.neighborCache.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p() - 1));
            this.neighborCache.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p() + 1));
        }
        if (this.searchDownwards) {
            this.neighborCache.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p()));
            this.neighborCache.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o() - 1, pos.func_177952_p()));
            this.neighborCache.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p() - 1));
            this.neighborCache.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p() + 1));
        }
    }
}

