/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.item.ItemBlockBase;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.util.MultiBlockHelper;

public class ItemBlockCoffin
extends ItemBlockBase {
    public ItemBlockCoffin(Block block) {
        super(block);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return MultiBlockHelper.onMultiBlockItemUse(this, player, world, pos, hand, facing, hitX, hitY, hitZ, this::mayPlace);
    }

    private boolean mayPlace(World world, BlockPos pos, EnumFacing sidePlacedOn, EntityPlayer placer) {
        return ItemBlockCoffin.canPlaceHorizontal(world, pos, sidePlacedOn, (EntityLivingBase)placer) || ItemBlockCoffin.canPlaceVertical(world, pos, sidePlacedOn);
    }

    public static boolean canPlaceVertical(World world, BlockPos pos, EnumFacing sidePlacedOn) {
        for (int offset = 0; offset < 3; ++offset) {
            if (ItemBlockCoffin.mayPlaceAt(world, pos.func_177967_a(EnumFacing.UP, offset), sidePlacedOn, offset == 0)) continue;
            return false;
        }
        return true;
    }

    public static boolean canPlaceHorizontal(World world, BlockPos pos, EnumFacing sidePlacedOn, EntityLivingBase placer) {
        EnumFacing facing = placer.func_174811_aO();
        for (int offset = 1; offset < 3; ++offset) {
            if (ItemBlockCoffin.mayPlaceAt(world, pos.func_177967_a(facing, offset), sidePlacedOn, offset == 0)) continue;
            return false;
        }
        return true;
    }

    private static boolean mayPlaceAt(World world, BlockPos pos, EnumFacing sidePlacedOn, boolean checkSide) {
        IBlockState state = world.func_180495_p(pos);
        AxisAlignedBB axisalignedbb = state.func_177230_c().func_176223_P().func_185890_d((IBlockAccess)world, pos);
        if (axisalignedbb != Block.field_185506_k && !world.func_72917_a(axisalignedbb.func_186670_a(pos), null)) {
            return false;
        }
        if (state.func_185904_a() == Material.field_151594_q && state.func_177230_c() == Blocks.field_150467_bQ) {
            return true;
        }
        return state.func_177230_c().func_176200_f((IBlockAccess)world, pos) && (!checkSide || world.func_180495_p(pos).func_177230_c().func_176198_a(world, pos, sidePlacedOn));
    }

    public static int getVariant(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e("variant") : 1;
    }

    public static ItemStack getVariantStack(int variant) {
        ItemStack stack = new ItemStack(AWStructureBlocks.COFFIN);
        stack.func_77982_d(new NBTBuilder().setInteger("variant", variant).build());
        return stack;
    }
}

