/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class ItemStructureBuilderWorldGen
extends ItemBaseStructure
implements IItemKeyInterface {
    public ItemStructureBuilderWorldGen(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        String structure = "guistrings.structure.no_selection";
        ItemStructureSettings viewSettings = ItemStructureSettings.getSettingsFor(stack);
        if (viewSettings.hasName()) {
            structure = viewSettings.name;
        }
        tooltip.add(I18n.func_135052_a((String)"guistrings.current_structure", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)structure, (Object[])new Object[0]));
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStructureSettings buildSettings = ItemStructureSettings.getSettingsFor(stack);
        if (buildSettings.hasName()) {
            BlockPos bpHit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
            if (bpHit == null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("block.not_found", new Object[0]));
                return;
            }
            Optional<StructureTemplate> template = StructureTemplateManager.getTemplate(buildSettings.name);
            if (!template.isPresent()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.template.not_found", new Object[0]));
                return;
            }
            StructureMap map = AWGameData.INSTANCE.getData(player.field_70170_p, StructureMap.class);
            WorldStructureGenerator.INSTANCE.attemptStructureGenerationAt(player.field_70170_p, bpHit, player.func_174811_aO(), template.get(), map);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.no_selection", new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && !player.func_70093_af()) {
            NetworkHandler.INSTANCE.openGui(player, 2, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

