/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public class ItemStructureSettings {
    private static final String STRUCT_DATA_TAG = "structData";
    private static final String BUILD_KEY_TAG = "buildKey";
    private BlockPos pos1 = BlockPos.field_177992_a;
    private BlockPos pos2 = BlockPos.field_177992_a;
    BlockPos key = BlockPos.field_177992_a;
    EnumFacing buildFace;
    String name = "";

    private ItemStructureSettings() {
    }

    public static ItemStructureSettings getSettingsFor(ItemStack stack) {
        ItemStructureSettings settings = new ItemStructureSettings();
        NBTTagCompound tag = stack.func_77942_o() && stack.func_77978_p().func_74764_b(STRUCT_DATA_TAG) ? stack.func_77978_p().func_74775_l(STRUCT_DATA_TAG) : new NBTTagCompound();
        if (tag.func_74764_b("pos1")) {
            settings.pos1 = BlockPos.func_177969_a((long)tag.func_74763_f("pos1"));
        }
        if (tag.func_74764_b("pos2")) {
            settings.pos2 = BlockPos.func_177969_a((long)tag.func_74763_f("pos2"));
        }
        if (tag.func_74764_b(BUILD_KEY_TAG)) {
            settings.key = BlockPos.func_177969_a((long)tag.func_74775_l(BUILD_KEY_TAG).func_74763_f("key"));
            settings.buildFace = EnumFacing.field_82609_l[tag.func_74775_l(BUILD_KEY_TAG).func_74771_c("face")];
        }
        if (tag.func_74764_b("name")) {
            settings.name = tag.func_74779_i("name");
        }
        return settings;
    }

    public static void setSettingsFor(ItemStack item, ItemStructureSettings settings) {
        NBTTagCompound tag = new NBTTagCompound();
        if (settings.hasPos1()) {
            tag.func_74772_a("pos1", settings.getPos1().func_177986_g());
        }
        if (settings.hasPos2()) {
            tag.func_74772_a("pos2", settings.getPos2().func_177986_g());
        }
        if (settings.hasBuildKey()) {
            NBTTagCompound buildKeyTag = new NBTTagCompound();
            buildKeyTag.func_74774_a("face", (byte)settings.buildFace.ordinal());
            buildKeyTag.func_74772_a("key", settings.key.func_177986_g());
            tag.func_74782_a(BUILD_KEY_TAG, (NBTBase)buildKeyTag);
        }
        if (settings.hasName()) {
            tag.func_74778_a("name", settings.name);
        }
        item.func_77983_a(STRUCT_DATA_TAG, (NBTBase)tag);
    }

    public void setPos1(BlockPos pos) {
        this.pos1 = pos;
    }

    public void setPos2(BlockPos pos) {
        this.pos2 = pos;
    }

    public void setBuildKey(BlockPos pos, EnumFacing face) {
        this.key = pos;
        this.buildFace = face;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasPos1() {
        return this.pos1 != BlockPos.field_177992_a;
    }

    public boolean hasPos2() {
        return this.pos2 != BlockPos.field_177992_a;
    }

    public boolean hasBuildKey() {
        return this.key != BlockPos.field_177992_a;
    }

    public boolean hasName() {
        return !this.name.isEmpty();
    }

    public BlockPos buildKey() {
        return this.key;
    }

    public EnumFacing face() {
        return this.buildFace;
    }

    public String name() {
        return this.name;
    }

    void clearSettings() {
        this.pos1 = BlockPos.field_177992_a;
        this.pos2 = BlockPos.field_177992_a;
        this.key = BlockPos.field_177992_a;
        this.name = "";
    }

    public BlockPos getPos1() {
        return this.pos1;
    }

    public BlockPos getPos2() {
        return this.pos2;
    }

    public BlockPos getMin() {
        return BlockTools.getMin(this.pos1, this.pos2);
    }

    public BlockPos getMax() {
        return BlockTools.getMax(this.pos1, this.pos2);
    }

    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB(this.getMin(), this.getMax());
    }
}

