/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.tile.TileSoundBlock;

public class PacketSoundBlockPlayerSpecValues
extends PacketBase {
    private BlockPos tilePos;
    private boolean stopped;
    private long lastTimePlayerNear;
    private int numberOfTimesRepeated;

    public PacketSoundBlockPlayerSpecValues() {
    }

    public PacketSoundBlockPlayerSpecValues(BlockPos tilePos, TileSoundBlock.PersistentValues values) {
        this.tilePos = tilePos;
        this.stopped = values.isStopped();
        this.lastTimePlayerNear = values.getLastTimePlayerNear();
        this.numberOfTimesRepeated = values.getNumberOfTimesRepeated();
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        data.writeLong(this.tilePos.func_177986_g());
        data.writeBoolean(this.stopped);
        data.writeLong(this.lastTimePlayerNear);
        data.writeInt(this.numberOfTimesRepeated);
    }

    @Override
    protected void readFromStream(ByteBuf data) throws IOException {
        this.tilePos = BlockPos.func_177969_a((long)data.readLong());
        this.stopped = data.readBoolean();
        this.lastTimePlayerNear = data.readLong();
        this.numberOfTimesRepeated = data.readInt();
    }

    @Override
    protected void execute(EntityPlayer player) {
        WorldTools.getTile((IBlockAccess)player.field_70170_p, this.tilePos, TileSoundBlock.class).ifPresent(tile -> tile.updatePlayerSpecValues(player.func_110124_au(), this.stopped, this.lastTimePlayerNear, this.numberOfTimesRepeated));
    }
}

