/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render;

import codechicken.lib.render.CCModelState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.TransformUtils;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.shadowmage.ancientwarfare.structure.block.BlockMulti;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockCoffin;
import net.shadowmage.ancientwarfare.structure.model.ModelCoffin;
import net.shadowmage.ancientwarfare.structure.render.RenderLootInfo;
import net.shadowmage.ancientwarfare.structure.tile.TileCoffin;

public class CoffinRenderer
extends RenderLootInfo<TileCoffin>
implements IItemRenderer {
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:structure/coffin", "normal");
    private static final ModelCoffin COFFIN_MODEL = new ModelCoffin();
    private static final Map<Integer, ResourceLocation> TEXTURES = new HashMap<Integer, ResourceLocation>();
    private static final IModelState TRANSFORMS;

    public void render(TileCoffin te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a(te, x, y, z, partialTicks, destroyStage, alpha);
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() != AWStructureBlocks.COFFIN || ((Boolean)state.func_177229_b((IProperty)BlockMulti.INVISIBLE)).booleanValue()) {
            return;
        }
        float rotation = te.getDirection().getRotationAngle();
        boolean upright = te.getUpright();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + (double)2.16f), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)(-rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        if (upright) {
            if (rotation % 90.0f == 0.0f) {
                GlStateManager.func_179137_b((double)0.0, (double)-1.25, (double)1.85);
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)-1.25, (double)2.1);
            }
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.22f);
        }
        GlStateManager.func_179114_b((float)(upright ? 265.0f : 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.09f, (float)0.09f, (float)0.09f);
        this.func_147499_a(TEXTURES.get(te.getVariant()));
        float lidAngle = te.getPrevLidAngle() + (te.getLidAngle() - te.getPrevLidAngle()) * partialTicks;
        COFFIN_MODEL.renderAll((float)((double)(-lidAngle / 180.0f) * Math.PI));
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    @Override
    protected double getNameplateOffsetZ(TileCoffin te, double z) {
        if (!te.getUpright()) {
            return super.getNameplateOffsetZ(te, z);
        }
        double offSetZ = Math.max(Math.min(Minecraft.func_71410_x().field_71439_g.field_70161_v - (double)te.func_174877_v().func_177952_p(), 1.0), -1.0);
        return z + offSetZ;
    }

    @Override
    protected double getNameplateOffsetX(TileCoffin te, double x) {
        if (!te.getUpright()) {
            return super.getNameplateOffsetX(te, x);
        }
        double offSetX = Math.max(Math.min(Minecraft.func_71410_x().field_71439_g.field_70165_t - (double)te.func_174877_v().func_177958_n(), 1.0), -1.0);
        return x + offSetX;
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        int variant = ItemBlockCoffin.getVariant(stack);
        if (variant < 1) {
            return;
        }
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURES.get(variant));
        COFFIN_MODEL.renderAll();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179121_F();
    }

    public IModelState getTransforms() {
        return TRANSFORMS;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    static {
        for (int id = 1; id <= 6; ++id) {
            TEXTURES.put(id, new ResourceLocation("ancientwarfare", "textures/model/structure/coffin_" + id + ".png"));
        }
        EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
        TRSRTransformation thirdPerson = TransformUtils.create((float)0.0f, (float)3.0f, (float)5.0f, (float)75.0f, (float)180.0f, (float)180.0f, (float)0.015f);
        map.put(ItemCameraTransforms.TransformType.GUI, TransformUtils.create((float)6.0f, (float)5.0f, (float)0.0f, (float)60.0f, (float)225.0f, (float)200.0f, (float)0.035f));
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)180.0f, (float)0.025f));
        map.put(ItemCameraTransforms.TransformType.FIXED, TransformUtils.create((float)0.0f, (float)-4.0f, (float)-12.0f, (float)90.0f, (float)180.0f, (float)0.0f, (float)0.035f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft((TRSRTransformation)thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create((float)25.0f, (float)-15.0f, (float)-10.0f, (float)50.0f, (float)170.0f, (float)170.0f, (float)0.08f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create((float)25.0f, (float)-15.0f, (float)-10.0f, (float)50.0f, (float)170.0f, (float)170.0f, (float)0.08f));
        TRANSFORMS = new CCModelState(map);
    }
}

