/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render.gate;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.model.ModelGateBasic;

public class RenderGateBasic
extends Render {
    protected final ModelGateBasic model = new ModelGateBasic();

    public RenderGateBasic(RenderManager renderManager) {
        super(renderManager);
    }

    public final void func_76986_a(Entity entity, double d0, double d1, double d2, float f, float f1) {
        float width;
        GlStateManager.func_179094_E();
        EntityGate g = (EntityGate)entity;
        BlockPos min = this.getMin(g);
        BlockPos max = this.getMax(g);
        boolean wideOnXAxis = min.func_177958_n() != max.func_177958_n();
        float height = max.func_177956_o() - min.func_177956_o() + 1;
        float xOffset = 0.0f;
        float zOffset = 0.0f;
        float tx = 0.0f;
        float ty = -1.0f;
        float tz = 0.0f;
        float axisRotation = 0.0f;
        if (wideOnXAxis) {
            width = max.func_177958_n() - min.func_177958_n() + 1;
            xOffset = width * 0.5f - 0.5f;
            tx = 1.0f;
            axisRotation = 90.0f;
        } else {
            tz = 1.0f;
            width = max.func_177952_p() - min.func_177952_p() + 1;
            zOffset = -width * 0.5f + 0.5f;
        }
        GlStateManager.func_179109_b((float)(-xOffset), (float)0.0f, (float)zOffset);
        int y = 0;
        while ((float)y < height) {
            GlStateManager.func_179094_E();
            int x = 0;
            while ((float)x < width) {
                this.model.setModelRotation(axisRotation);
                if ((float)y == height - 1.0f && x > 0 && (float)x < width - 1.0f) {
                    this.model.renderTop();
                } else if ((float)y == height - 1.0f && x == 0) {
                    this.model.renderCorner();
                } else if ((float)y == height - 1.0f && (float)x == width - 1.0f) {
                    this.model.setModelRotation(axisRotation + 180.0f);
                    this.model.renderCorner();
                } else if (x == 0) {
                    this.model.renderSide();
                } else if ((float)x == width - 1.0f) {
                    this.model.setModelRotation(axisRotation + 180.0f);
                    this.model.renderSide();
                }
                this.postRender(g, x, width, y, height, wideOnXAxis, axisRotation, f1);
                GlStateManager.func_179109_b((float)tx, (float)0.0f, (float)tz);
                ++x;
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)ty, (float)0.0f);
            ++y;
        }
        GlStateManager.func_179121_F();
    }

    protected BlockPos getMin(EntityGate gate) {
        return gate.pos1;
    }

    protected BlockPos getMax(EntityGate gate) {
        return gate.pos2;
    }

    protected void postRender(EntityGate gate, int x, float width, int y, float height, boolean wideOnXAxis, float axisRotation, float frame) {
        if ((float)y + gate.edgePosition <= height - 0.475f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(-gate.edgePosition - gate.openingSpeed * (1.0f - frame)), (float)0.0f);
            this.model.setModelRotation(axisRotation);
            if (gate.getGateType().getModelType() == 0) {
                this.model.renderSolidWall();
            } else {
                this.model.renderBars();
            }
            GlStateManager.func_179121_F();
        }
    }

    protected final ResourceLocation func_110775_a(Entity entity) {
        return ((EntityGate)entity).getGateType().getTexture();
    }
}

