/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render.statue;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.render.statue.IStatueModel;
import net.shadowmage.ancientwarfare.structure.tile.EntityStatueInfo;

public abstract class StatueModelBase<T extends ModelBase>
implements IStatueModel {
    protected final T model;
    private Map<String, ModelRenderer> nameRenderer;

    public StatueModelBase(T model) {
        this.model = model;
        this.initiateNameRendererMap();
    }

    private void initiateNameRendererMap() {
        this.nameRenderer = this.getNameRendererMap();
    }

    protected static ModelRenderer getObfuscatedRenderer(ModelBase model, Field rendererField) {
        try {
            return (ModelRenderer)rendererField.get(model);
        }
        catch (IllegalAccessException e) {
            AncientWarfareStructure.LOG.error("Unable to get {} model renderer of {}: {}", (Object)rendererField.getName(), (Object)model.getClass().getSimpleName(), (Object)e);
            return new ModelRenderer(model);
        }
    }

    protected static ModelRenderer[] getObfuscatedRendererArray(ModelBase model, Field rendererField) {
        try {
            return (ModelRenderer[])rendererField.get(model);
        }
        catch (IllegalAccessException e) {
            AncientWarfareStructure.LOG.error("Unable to get {} model renderer array of {}: {}", (Object)rendererField.getName(), (Object)model.getClass().getSimpleName(), (Object)e);
            return new ModelRenderer[]{new ModelRenderer(model)};
        }
    }

    @Override
    public ModelBase getModel() {
        return this.model;
    }

    protected abstract Map<String, ModelRenderer> getNameRendererMap();

    @Override
    public Set<String> getModelPartNames() {
        return this.nameRenderer.keySet();
    }

    @Override
    public ModelRenderer getModelPart(String name) {
        return this.nameRenderer.getOrDefault(name, new ModelRenderer(this.model));
    }

    @Override
    public void render(float scale) {
        this.nameRenderer.forEach((name, renderer) -> renderer.func_78785_a(scale));
    }

    @Override
    public Map<String, EntityStatueInfo.Transform> getBaseTransforms() {
        return Collections.emptyMap();
    }
}

