/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3i;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.MathUtils;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntityBase;
import net.shadowmage.ancientwarfare.structure.template.StructurePluginManager;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.datafixes.DataFixManager;

public class StructureTemplate {
    public final String name;
    public final Vec3i size;
    public final Vec3i offset;
    private Version version;
    public final Set<String> modDependencies;
    private Map<Integer, TemplateRule> blockRules;
    private Map<Integer, TemplateRuleEntityBase> entityRules;
    private short[] templateData;
    private NonNullList<ItemStack> resourceList;
    private List<ItemStack> remainingStacks;
    private StructureValidator validator = StructureValidationType.GROUND.getValidator();

    public StructureTemplate(String name, Set<String> modDependencies, Vec3i size, Vec3i offset) {
        this(name, modDependencies, DataFixManager.getCurrentVersion(), size, offset);
    }

    public StructureTemplate(String name, Set<String> modDependencies, Version version, Vec3i size, Vec3i offset) {
        this.modDependencies = modDependencies;
        this.version = version;
        this.name = name;
        this.size = size;
        this.offset = offset;
    }

    public Map<Integer, TemplateRuleEntityBase> getEntityRules() {
        return this.entityRules;
    }

    public Map<Integer, TemplateRule> getBlockRules() {
        return this.blockRules;
    }

    public short[] getTemplateData() {
        return this.templateData;
    }

    public StructureValidator getValidationSettings() {
        return this.validator;
    }

    public void setBlockRules(Map<Integer, TemplateRule> rules) {
        this.blockRules = rules;
    }

    public void setEntityRules(Map<Integer, TemplateRuleEntityBase> rules) {
        this.entityRules = rules;
    }

    public void setTemplateData(short[] datas) {
        this.templateData = datas;
    }

    public void setValidationSettings(StructureValidator settings) {
        this.validator = settings;
    }

    public Optional<TemplateRuleBlock> getBlockRuleAt(Vec3i pos) {
        Optional<TemplateRule> rule = this.getRuleAt(pos);
        return !rule.isPresent() || !(rule.get() instanceof TemplateRuleBlock) ? Optional.empty() : Optional.of((TemplateRuleBlock)rule.get());
    }

    public Optional<TemplateRule> getRuleAt(Vec3i pos) {
        int index = StructureTemplate.getIndex(pos, this.size);
        int ruleIndex = index >= 0 && index < this.templateData.length ? this.templateData[index] : -1;
        return Optional.ofNullable(this.blockRules.get(ruleIndex));
    }

    public static int getIndex(Vec3i pos, Vec3i size) {
        return pos.func_177956_o() * size.func_177958_n() * size.func_177952_p() + pos.func_177952_p() * size.func_177958_n() + pos.func_177958_n();
    }

    public String toString() {
        return "name: " + this.name + "\nsize: " + this.size.func_177958_n() + ", " + this.size.func_177956_o() + ", " + this.size.func_177952_p() + "\nbuildKey: " + this.offset.func_177958_n() + ", " + this.offset.func_177956_o() + ", " + this.offset.func_177952_p();
    }

    public NonNullList<ItemStack> getResourceList() {
        if (this.resourceList == null) {
            NonNullList stacks = NonNullList.func_191196_a();
            MathUtils.getAllVecsInBox(Vec3i.field_177959_e, new Vec3i(this.size.func_177958_n() - 1, this.size.func_177956_o() - 1, this.size.func_177952_p() - 1)).forEach(pos -> this.getRuleAt((Vec3i)pos).ifPresent(r -> r.addResources((NonNullList<ItemStack>)stacks)));
            this.resourceList = InventoryTools.compactStackList((NonNullList<ItemStack>)stacks);
        }
        return this.resourceList;
    }

    public List<ItemStack> getRemainingStacks() {
        if (this.remainingStacks == null) {
            NonNullList stacks = NonNullList.func_191196_a();
            MathUtils.getAllVecsInBox(Vec3i.field_177959_e, new Vec3i(this.size.func_177958_n() - 1, this.size.func_177956_o() - 1, this.size.func_177952_p() - 1)).forEach(pos -> this.getRuleAt((Vec3i)pos).ifPresent(r -> {
                ItemStack stack = r.getRemainingStack();
                if (!stack.func_190926_b()) {
                    stacks.add((Object)stack);
                }
            }));
            this.remainingStacks = InventoryTools.compactStackList((NonNullList<ItemStack>)stacks);
        }
        return this.remainingStacks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructureTemplate)) {
            return false;
        }
        StructureTemplate that = (StructureTemplate)o;
        return this.size.equals((Object)that.size) && this.offset.equals((Object)that.offset) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.size.hashCode();
        result = 31 * result + this.offset.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public Version getVersion() {
        return this.version;
    }

    public Vec3i getSize() {
        return this.size;
    }

    public Vec3i getOffset() {
        return this.offset;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("name", this.name);
        tag.func_74772_a("size", MathUtils.toLong(this.size));
        tag.func_74772_a("offset", MathUtils.toLong(this.offset));
        tag.func_74782_a("blockRules", (NBTBase)this.serializeRules(this.blockRules));
        tag.func_74782_a("entityRules", (NBTBase)this.serializeRules(this.entityRules));
        tag.func_74783_a("templateData", MathUtils.toIntArray(this.templateData));
        tag.func_74778_a("validationType", this.validator.validationType.getName());
        tag.func_74782_a("validator", (NBTBase)this.validator.serializeToNBT());
        return tag;
    }

    public static StructureTemplate deserializeNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("name");
        Vec3i size = MathUtils.fromLong(tag.func_74763_f("size"));
        Vec3i offset = MathUtils.fromLong(tag.func_74763_f("offset"));
        StructureTemplate template = new StructureTemplate(name, Collections.emptySet(), size, offset);
        template.setBlockRules(StructureTemplate.deserializeRules(tag.func_150295_c("blockRules", 10)));
        template.setEntityRules(StructureTemplate.deserializeRules(tag.func_150295_c("entityRules", 10)));
        template.setTemplateData(MathUtils.toShortArray(tag.func_74759_k("templateData")));
        StructureValidationType.getTypeFromName(tag.func_74779_i("validationType")).ifPresent(type -> {
            StructureValidator structureValidator = type.getValidator();
            structureValidator.readFromNBT(tag.func_74775_l("validator"));
            template.setValidationSettings(structureValidator);
        });
        return template;
    }

    private static <T extends TemplateRule> Map<Integer, T> deserializeRules(NBTTagList blockRules) {
        HashMap ret = new HashMap();
        for (NBTBase data : blockRules) {
            NBTTagCompound ruleData = (NBTTagCompound)data;
            StructurePluginManager.INSTANCE.getRuleByName(ruleData.func_74779_i("pluginName")).ifPresent(rule -> {
                rule.parseRule(ruleData);
                ret.put(ruleData.func_74762_e("ruleNumber"), rule);
            });
        }
        return ret;
    }

    private NBTTagList serializeRules(Map<Integer, ? extends TemplateRule> templateRules) {
        return templateRules.entrySet().stream().map(this::serializeRule).collect(NBTHelper.NBTLIST_COLLECTOR);
    }

    private NBTTagCompound serializeRule(Map.Entry<Integer, ? extends TemplateRule> blockRule) {
        NBTTagCompound ruleData = new NBTTagCompound();
        ruleData.func_74768_a("ruleNumber", blockRule.getKey().intValue());
        ruleData.func_74778_a("pluginName", blockRule.getValue().getPluginName());
        blockRule.getValue().writeRuleData(ruleData);
        return ruleData;
    }

    public static class Version {
        private final int major;
        private final int minor;
        public static final Version NONE = new Version(0, 0);

        public Version(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public Version(String version) {
            this(Integer.valueOf(version.substring(0, version.indexOf(46))), Integer.valueOf(version.substring(version.indexOf(46) + 1)));
        }

        public boolean isGreaterThan(Version otherVersion) {
            return this.getMajor() > otherVersion.getMajor() || this.getMinor() > otherVersion.getMinor();
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }
    }
}

