/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;

public class WorldGenStructureManager {
    private HashMap<String, Set<StructureTemplate>> templatesByBiome = new HashMap();
    private List<StructureEntry> searchCache = new ArrayList<StructureEntry>();
    private List<StructureTemplate> trimmedPotentialStructures = new ArrayList<StructureTemplate>();
    private HashMap<String, Integer> distancesFound = new HashMap();
    BlockPos rearBorderPos = BlockPos.field_177992_a;
    public static final WorldGenStructureManager INSTANCE = new WorldGenStructureManager();

    private WorldGenStructureManager() {
    }

    public void loadBiomeList() {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null) continue;
            this.templatesByBiome.put(biome.getRegistryName().toString(), new HashSet());
        }
    }

    public void registerWorldGenStructure(StructureTemplate template) {
        StructureValidator validation = template.getValidationSettings();
        Set<String> biomes = validation.getBiomeList();
        if (validation.isBiomeWhiteList()) {
            for (String biome : biomes) {
                if (this.templatesByBiome.containsKey(biome)) {
                    this.templatesByBiome.get(biome).add(template);
                    continue;
                }
                if (!Loader.isModLoaded((String)new ResourceLocation(biome).func_110624_b())) continue;
                AncientWarfareStructure.LOG.warn("Could not locate biome: " + biome + " while registering template: " + template.name + " for world generation.");
            }
        } else {
            for (String biome : this.templatesByBiome.keySet()) {
                if (!biomes.isEmpty() && biomes.contains(biome.toLowerCase(Locale.ENGLISH))) continue;
                this.templatesByBiome.get(biome).add(template);
            }
        }
    }

    public StructureTemplate selectTemplateForGeneration(World world, Random rng, int x, int y, int z, EnumFacing face) {
        this.searchCache.clear();
        this.trimmedPotentialStructures.clear();
        this.distancesFound.clear();
        StructureMap map = AWGameData.INSTANCE.getData(world, StructureMap.class);
        if (map == null) {
            return null;
        }
        int foundValue = 0;
        Biome biome = world.field_73011_w.getBiomeForCoords(new BlockPos(x, 1, z));
        String biomeName = biome.getRegistryName().toString();
        Collection<StructureEntry> duplicateSearchEntries = map.getEntriesNear(world, x, z, AWStructureStatics.duplicateStructureSearchRange, false, this.searchCache);
        for (StructureEntry structureEntry : duplicateSearchEntries) {
            float mx = structureEntry.getBB().getCenterX() - x;
            float mz = structureEntry.getBB().getCenterZ() - z;
            float foundDistance = MathHelper.func_76129_c((float)(mx * mx + mz * mz));
            int chunkDistance = (int)(foundDistance / 16.0f);
            if (this.distancesFound.containsKey(structureEntry.getName())) {
                int dist = this.distancesFound.get(structureEntry.getName());
                if (chunkDistance >= dist) continue;
                this.distancesFound.put(structureEntry.getName(), chunkDistance);
                continue;
            }
            this.distancesFound.put(structureEntry.getName(), chunkDistance);
        }
        Collection<StructureEntry> clusterValueSearchEntries = map.getEntriesNear(world, x, z, AWStructureStatics.clusterValueSearchRange, false, this.searchCache);
        for (StructureEntry entry : clusterValueSearchEntries) {
            foundValue += entry.getValue();
        }
        Set<StructureTemplate> set = this.templatesByBiome.get(biomeName);
        if (set == null || set.isEmpty()) {
            return null;
        }
        int remainingValueCache = AWStructureStatics.maxClusterValue - foundValue;
        int dim = world.field_73011_w.getDimension();
        for (StructureTemplate template : set) {
            int dist;
            StructureValidator settings = template.getValidationSettings();
            boolean dimensionMatch = !settings.isDimensionWhiteList();
            for (int i = 0; i < settings.getAcceptedDimensions().length; ++i) {
                int dimTest = settings.getAcceptedDimensions()[i];
                if (dimTest != dim) continue;
                dimensionMatch = !dimensionMatch;
                break;
            }
            if (!dimensionMatch || settings.isUnique() && map.isGeneratedUnique(template.name) || settings.getClusterValue() > remainingValueCache || this.distancesFound.containsKey(template.name) && (dist = this.distancesFound.get(template.name).intValue()) < settings.getMinDuplicateDistance() || !settings.shouldIncludeForSelection(world, x, y, z, face, template)) continue;
            this.trimmedPotentialStructures.add(template);
        }
        if (this.trimmedPotentialStructures.isEmpty()) {
            return null;
        }
        StructureTemplate toReturn = this.getWeightedRandomStructure(rng);
        this.distancesFound.clear();
        this.trimmedPotentialStructures.clear();
        return toReturn;
    }

    @Nullable
    private StructureTemplate getWeightedRandomStructure(Random rng) {
        int totalWeight = 0;
        for (StructureTemplate t : this.trimmedPotentialStructures) {
            totalWeight += t.getValidationSettings().getSelectionWeight();
        }
        int rnd = rng.nextInt(totalWeight + 1);
        StructureTemplate toReturn = null;
        for (StructureTemplate t : this.trimmedPotentialStructures) {
            if ((rnd -= t.getValidationSettings().getSelectionWeight()) > 0) continue;
            toReturn = t;
            break;
        }
        return toReturn;
    }
}

