/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorGround;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorHarbor;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorIsland;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorSky;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorUnderground;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorUnderwater;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorWater;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.IStructureValidationProperty;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;

public enum StructureValidationType {
    GROUND(StructureValidatorGround::new, new IStructureValidationProperty[0]),
    UNDERGROUND(StructureValidatorUnderground::new, StructureValidationProperties.MIN_GENERATION_DEPTH, StructureValidationProperties.MAX_GENERATION_DEPTH, StructureValidationProperties.MIN_OVERFILL),
    SKY(StructureValidatorSky::new, StructureValidationProperties.MIN_GENERATION_HEIGHT, StructureValidationProperties.MAX_GENERATION_HEIGHT, StructureValidationProperties.MIN_FLYING_HEIGHT),
    WATER(StructureValidatorWater::new, new IStructureValidationProperty[0]),
    UNDERWATER(StructureValidatorUnderwater::new, StructureValidationProperties.MIN_WATER_DEPTH, StructureValidationProperties.MAX_WATER_DEPTH),
    HARBOR(StructureValidatorHarbor::new, new IStructureValidationProperty[0]),
    ISLAND(StructureValidatorIsland::new, StructureValidationProperties.MIN_WATER_DEPTH, StructureValidationProperties.MAX_WATER_DEPTH);

    private final Supplier<? extends StructureValidator> createValidator;
    private List<IStructureValidationProperty> properties = new ArrayList<IStructureValidationProperty>();

    private StructureValidationType(Supplier<? extends StructureValidator> createValidator, IStructureValidationProperty ... props) {
        this.createValidator = createValidator;
        Collections.addAll(this.properties, StructureValidationProperties.SURVIVAL, StructureValidationProperties.WORLD_GEN, StructureValidationProperties.UNIQUE, StructureValidationProperties.PRESERVE_BLOCKS, StructureValidationProperties.SELECTION_WEIGHT, StructureValidationProperties.CLUSTER_VALUE, StructureValidationProperties.MIN_DUPLICATE_DISTANCE, StructureValidationProperties.DIMENSION_WHITE_LIST, StructureValidationProperties.DIMENSION_LIST, StructureValidationProperties.BIOME_WHITE_LIST, StructureValidationProperties.BIOME_LIST, StructureValidationProperties.MAX_LEVELING, StructureValidationProperties.MAX_FILL, StructureValidationProperties.BORDER_SIZE, StructureValidationProperties.BLOCK_SWAP);
        Collections.addAll(this.properties, props);
    }

    public List<IStructureValidationProperty> getValidationProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public StructureValidator getValidator() {
        return this.createValidator.get();
    }

    public static Optional<StructureValidationType> getTypeFromName(String name) {
        try {
            return Optional.of(StructureValidationType.valueOf(name.toUpperCase(Locale.ENGLISH)));
        }
        catch (IllegalArgumentException illegal) {
            return Optional.empty();
        }
    }
}

