/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.SmoothingMatrixBuilder;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class StructureValidatorGround
extends StructureValidator {
    public StructureValidatorGround() {
        super(StructureValidationType.GROUND);
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, EnumFacing face, StructureTemplate template) {
        IBlockState state = world.func_180495_p(new BlockPos(x, y - 1, z));
        Block block = state.func_177230_c();
        if (!AWStructureStatics.isValidTargetBlock(state)) {
            AncientWarfareStructure.LOG.debug("Rejecting due to target block mismatch of: " + block.getRegistryName().toString() + " at: " + x + "," + y + "," + z);
            return false;
        }
        return true;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        if (y - template.offset.func_177956_o() <= 0) {
            AncientWarfareStructure.LOG.debug("Ground isn't deep enough for the structure- required: {}, found: {}", (Object)Math.abs(bb.min.func_177956_o()), (Object)y);
            return false;
        }
        int minY = this.getMinY(template, bb);
        int maxY = this.getMaxY(template, bb);
        return this.validateBorderBlocks(world, bb, minY, maxY, false);
    }

    @Override
    public void preGeneration(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureBB bb) {
        if (!this.isPreserveBlocks()) {
            this.clearBB(world, template, bb);
            this.prePlacementUnderfill(world, bb);
        }
    }

    private void smoothoutBorder(World world, StructureBB bb, StructureTemplate template) {
        int borderSize = this.getBorderSize();
        if (borderSize > 0) {
            new SmoothingMatrixBuilder(world, bb, borderSize, bb.min.func_177956_o() + template.getOffset().func_177956_o() - 1).build().apply(world, pos -> this.handleClearAction(world, (BlockPos)pos, template, bb));
        }
    }

    private void clearBB(World world, StructureTemplate template, StructureBB bb) {
        BlockTools.getAllInBoxTopDown(bb.min, bb.max.func_177982_a(0, 10, 0)).forEach(pos -> this.handleClearAction(world, (BlockPos)pos, template, bb));
    }

    @Override
    public void postGeneration(World world, BlockPos origin, StructureBB bb, StructureTemplate template) {
        if (!this.isPreserveBlocks()) {
            this.smoothoutBorder(world, bb, template);
        }
        if (world.func_175708_f(origin.func_177984_a(), false)) {
            WorldStructureGenerator.sprinkleSnow(world, bb, this.getBorderSize());
        }
    }
}

