/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class StructureValidatorUnderwater
extends StructureValidator {
    public StructureValidatorUnderwater() {
        super(StructureValidationType.UNDERWATER);
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, EnumFacing face, StructureTemplate template) {
        int startY = y;
        int water = startY - (y = WorldStructureGenerator.getTargetY(world, x, z, true) + 1);
        return water >= this.getPropertyValue(StructureValidationProperties.MIN_WATER_DEPTH) && water <= this.getPropertyValue(StructureValidationProperties.MAX_WATER_DEPTH);
    }

    @Override
    public int getAdjustedSpawnY(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        return WorldStructureGenerator.getTargetY(world, x, z, true) + 1;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        int minY = this.getMinY(template, bb);
        int maxY = this.getMaxY(template, bb);
        return this.validateBorderBlocks(world, bb, minY, maxY, true);
    }

    @Override
    public void preGeneration(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureBB bb) {
        this.prePlacementBorder(world, template, bb);
        this.prePlacementUnderfill(world, bb);
    }

    @Override
    public void handleClearAction(World world, BlockPos pos, StructureTemplate template, StructureBB bb) {
        world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
    }
}

