/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.border;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.BorderMatrix;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.BorderMatrixCache;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.HorizontalCoords;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.SmoothingMatrix;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.BorderPoint;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.PointType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.SmoothingPoint;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class SmoothingMatrixBuilder {
    private final World world;
    private final int borderSize;
    private final int groundY;
    private final SmoothingMatrix smoothingMatrix;
    private static final Set<Block> STRUCTURE_BORDER_BLOCK_WHITELIST = ImmutableSet.of((Object)Blocks.field_150348_b, (Object)Blocks.field_150351_n, (Object)Blocks.field_150346_d, (Object)Blocks.field_150349_c, (Object)Blocks.field_150354_m, (Object)Blocks.field_150322_A, (Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150341_Y, Blocks.field_150343_Z, Blocks.field_150433_aE, Blocks.field_150424_aL, Blocks.field_150425_aM, Blocks.field_150391_bh, Blocks.field_150377_bs, Blocks.field_150405_ch, Blocks.field_150435_aG, Blocks.field_185774_da, Blocks.field_150432_aD, Blocks.field_150403_cj, Blocks.field_150355_j, Blocks.field_150353_l, Blocks.field_180395_cM, Blocks.field_150406_ce});

    public SmoothingMatrixBuilder(World world, StructureBB bb, int borderSize, int groundY) {
        this.world = world;
        this.borderSize = borderSize;
        this.groundY = groundY;
        BorderMatrix borderMatrix = BorderMatrixCache.getBorderMatrix(bb.getXSize(), bb.getZSize(), borderSize);
        this.smoothingMatrix = new SmoothingMatrix(borderMatrix, bb.min, borderSize);
        this.convertPointsToSmoothingMatrix(groundY, borderMatrix, PointType.STRUCTURE_BORDER);
        this.convertPointsToSmoothingMatrix(0, borderMatrix, PointType.REFERENCE_POINT);
        this.convertPointsToSmoothingMatrix(0, borderMatrix, PointType.OUTER_BORDER);
        this.convertPointsToSmoothingMatrix(0, borderMatrix, PointType.SMOOTHED_BORDER);
    }

    private void convertPointsToSmoothingMatrix(int groundY, BorderMatrix borderMatrix, PointType type) {
        for (BorderPoint point : borderMatrix.getPointsOfType(type)) {
            SmoothingPoint smoothingPoint;
            if (type == PointType.SMOOTHED_BORDER) {
                smoothingPoint = this.addPoint(point.getX(), point.getZ(), PointType.SMOOTHED_BORDER, (x, z) -> this.getYBelowFloatingIsland(this.getMinPos().func_177958_n() + x, BlockTools.getTopFilledHeight(this.world, this.getMinPos().func_177958_n() + x, this.getMinPos().func_177952_p() + z, false), this.getMinPos().func_177952_p() + z, false));
                BorderPoint outerBorder = point.getOuterBorderPoint();
                BorderPoint ref = point.getReferencePoint();
                Optional<SmoothingPoint> outerBorderPoint = this.smoothingMatrix.getPoint(outerBorder.getX(), outerBorder.getZ());
                Optional<SmoothingPoint> refPoint = this.smoothingMatrix.getPoint(ref.getX(), ref.getZ());
                if (outerBorderPoint.isPresent() && refPoint.isPresent()) {
                    smoothingPoint.setOuterBorderAndReferencePoint(outerBorderPoint.get(), refPoint.get());
                }
            } else {
                smoothingPoint = this.addPoint(point.getX(), point.getZ(), point.getType(), groundY);
            }
            if (type != PointType.OUTER_BORDER && type != PointType.SMOOTHED_BORDER) continue;
            BorderPoint borderPoint = point.getClosestBorderPoint();
            this.smoothingMatrix.getPoint(borderPoint.getX(), borderPoint.getZ()).ifPresent(p -> smoothingPoint.setStructureBorder((SmoothingPoint)p, point.getStructureBorderDistance()));
        }
    }

    public SmoothingMatrix build() {
        this.calculateNewYLevelsAndBlocks();
        this.processSmoothing();
        return this.smoothingMatrix;
    }

    private void processSmoothing() {
        for (SmoothingPoint point : this.smoothingMatrix.getPointsOfType(PointType.SMOOTHED_BORDER)) {
            int totalY = point.getSmoothedPos().func_177956_o();
            BlockPos currentPos = point.getSmoothedPos();
            HorizontalCoords current = new HorizontalCoords(point.getX(), point.getZ());
            for (HorizontalCoords adjacent : HorizontalCoords.ADJACENT_OFFSETS) {
                Optional<SmoothingPoint> adjacentPoint = this.smoothingMatrix.getPoint(current.add(adjacent));
                if (!adjacentPoint.isPresent()) continue;
                totalY += adjacentPoint.get().getSmoothedPos().func_177956_o();
            }
            int averageY = Math.round((float)totalY / 5.0f);
            if (currentPos.func_177956_o() == averageY) continue;
            point.setSmoothedPos(new BlockPos(currentPos.func_177958_n(), averageY, currentPos.func_177952_p()));
        }
    }

    private void calculateNewYLevelsAndBlocks() {
        for (SmoothingPoint pointToSmooth : this.smoothingMatrix.getPointsOfType(PointType.SMOOTHED_BORDER)) {
            SmoothingPoint referencePoint = pointToSmooth.getReferencePoint();
            SmoothingPoint outerBorderPoint = pointToSmooth.getOuterBorderPoint();
            double outerDistToStructure = outerBorderPoint.getStructureBorderDistance();
            int structureBorderY = outerBorderPoint.getClosestBorderPoint().getWorldPos().func_177956_o();
            int yDiff = outerBorderPoint.getWorldPos().func_177956_o() - structureBorderY;
            boolean steepFormula = yDiff >= 0 ? referencePoint.getWorldPos().func_177956_o() - outerBorderPoint.getWorldPos().func_177956_o() > 2 : referencePoint.getWorldPos().func_177956_o() - outerBorderPoint.getWorldPos().func_177956_o() < -2;
            double pointDist = pointToSmooth.getStructureBorderDistance();
            if (steepFormula) {
                double ratio = pointDist / outerDistToStructure;
                this.setNewSmoothedY(pointToSmooth, structureBorderY + (int)Math.round((double)yDiff * ratio * ratio));
            } else {
                double ratio;
                double halfDist = outerDistToStructure / 2.0;
                int halfYDiff = yDiff / 2;
                if (pointDist <= halfDist) {
                    ratio = pointDist / halfDist;
                    this.setNewSmoothedY(pointToSmooth, structureBorderY + (int)Math.round((double)halfYDiff * ratio * ratio));
                } else {
                    ratio = (outerDistToStructure - pointDist) / halfDist;
                    this.setNewSmoothedY(pointToSmooth, outerBorderPoint.getWorldPos().func_177956_o() - (int)Math.round((double)halfYDiff * ratio * ratio));
                }
            }
            this.setBlockStateForPoint(outerBorderPoint, outerDistToStructure, yDiff, pointToSmooth, pointDist);
        }
    }

    private void setBlockStateForPoint(SmoothingPoint outerBorderPoint, double outerDistToStructure, int yDiff, SmoothingPoint pointToSmooth, double pointDist) {
        if (!pointToSmooth.getClosestBorderPoint().useStateForBlending()) {
            pointToSmooth.setBlockState(outerBorderPoint.getBlockState());
            return;
        }
        if (Math.round((double)yDiff / outerDistToStructure) < 2L) {
            pointToSmooth.setBlockState(this.world.field_73012_v.nextDouble() > pointDist / outerDistToStructure ? pointToSmooth.getClosestBorderPoint().getBlockState() : outerBorderPoint.getBlockState());
        } else {
            pointToSmooth.setBlockState(this.world.func_180494_b((BlockPos)pointToSmooth.getWorldPos()).field_76752_A);
        }
    }

    private void setNewSmoothedY(SmoothingPoint pointToSmooth, int newY) {
        pointToSmooth.setSmoothedPos(new BlockPos(pointToSmooth.getWorldPos().func_177958_n(), newY, pointToSmooth.getWorldPos().func_177952_p()));
    }

    private SmoothingPoint addPoint(int x, int z, PointType type, int yLevel) {
        return this.addPoint(x, z, type, (xCoord, zCoord) -> this.getY((int)xCoord, (int)zCoord, yLevel));
    }

    private SmoothingPoint addPoint(int x, int z, PointType type, BiFunction<Integer, Integer, Integer> getY) {
        BlockPos pos = new BlockPos(this.getMinPos().func_177958_n() + x, getY.apply(x, z).intValue(), this.getMinPos().func_177952_p() + z);
        Optional<IBlockState> state = this.getPointBlockState(pos, type);
        return state.map(iBlockState -> this.smoothingMatrix.addPoint(x, z, pos, type, (IBlockState)iBlockState)).orElseGet(() -> this.smoothingMatrix.addPoint(x, z, pos, type));
    }

    private int getY(int x, int z, int yLevel) {
        int y = yLevel;
        if (yLevel == 0) {
            y = WorldStructureGenerator.getTargetY(this.world, this.getMinPos().func_177958_n() + x, this.getMinPos().func_177952_p() + z, true);
            y = this.getYBelowFloatingIsland(this.getMinPos().func_177958_n() + x, y, this.getMinPos().func_177952_p() + z);
        }
        return y;
    }

    private BlockPos getMinPos() {
        return this.smoothingMatrix.getMinPos();
    }

    private Optional<IBlockState> getPointBlockState(BlockPos pos, PointType type) {
        IBlockState state = this.world.func_180495_p(pos);
        if (type == PointType.STRUCTURE_BORDER && !STRUCTURE_BORDER_BLOCK_WHITELIST.contains(state.func_177230_c())) {
            return Optional.empty();
        }
        return Optional.of(state);
    }

    private int getYBelowFloatingIsland(int x, int y, int z) {
        return this.getYBelowFloatingIsland(x, y, z, true);
    }

    private int getYBelowFloatingIsland(int x, int y, int z, boolean useSkippables) {
        if (y - this.groundY > this.borderSize) {
            int newY;
            int startAtY = this.groundY + (y - this.groundY) / 2;
            int n = newY = useSkippables ? WorldStructureGenerator.getTargetY(this.world, x, z, true, startAtY) : BlockTools.getTopFilledHeight(this.world, x, z, false, startAtY);
            if (newY != startAtY) {
                return newY;
            }
        }
        return y;
    }
}

