/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes.fixers;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleDataFixerBase;

public class EntityEquipmentFixer
extends RuleDataFixerBase {
    private static final StructureTemplate.Version VERSION = new StructureTemplate.Version(2, 8);
    private static final Set<String> APPLICABLE_TO_RULES = ImmutableSet.of((Object)"AWNpc", (Object)"vanillaLogicEntity");

    @Override
    public StructureTemplate.Version getVersion() {
        return VERSION;
    }

    @Override
    public boolean isForRule(String ruleName) {
        return APPLICABLE_TO_RULES.contains(ruleName);
    }

    @Override
    protected FixResult<String> fixData(String ruleName, String data) {
        NBTTagCompound tag;
        try {
            tag = JsonToNBT.func_180713_a((String)data.substring("JSON:".length()));
        }
        catch (NBTException e) {
            AncientWarfareStructure.LOG.error("Error getting nbt from json string: ", (Throwable)e);
            return new FixResult.NotModified<String>(data);
        }
        if (!tag.func_74764_b("equipmentData")) {
            return new FixResult.NotModified<String>(data);
        }
        NBTTagList equipmentList = tag.func_74775_l("equipmentData").func_150295_c("equipmentContents", 10);
        NBTTagList handItems = new NBTTagList();
        NBTTagList armorItems = new NBTTagList();
        for (int i = 0; i < equipmentList.func_74745_c(); ++i) {
            NBTTagCompound stack = equipmentList.func_150305_b(i);
            stack.func_82580_o("slot");
            if (i < 2) {
                handItems.func_74742_a((NBTBase)stack);
                continue;
            }
            armorItems.func_74742_a((NBTBase)stack);
        }
        NBTTagCompound entityData = tag.func_74775_l("entityData");
        entityData.func_74782_a("HandItems", (NBTBase)handItems);
        entityData.func_74782_a("ArmorItems", (NBTBase)armorItems);
        tag.func_74782_a("entityData", (NBTBase)entityData);
        return new FixResult.Modified<String>("JSON:" + tag.toString(), "EntityEquipmentFixer");
    }
}

